package com.alibaba.dts.client.executor.parallel.processor;

import com.alibaba.dts.client.executor.job.context.JobContextImpl;
import com.alibaba.dts.client.executor.parallel.processor.FailureJobContext;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.JobInstanceSnapshot;

/**
 * 失败job处理器上下文
 * @author tianyao.myc
 *
 */
public class FailureJobContextImpl extends JobContextImpl implements Constants,FailureJobContext {

	public FailureJobContextImpl(Job job, JobInstanceSnapshot jobInstanceSnapshot, int retryCount) {
		super(job, jobInstanceSnapshot, retryCount);
	}
	
	/** 当前要处理的任务 */
	private Object task;
	
	/** 异常 */
	private Throwable e;
	
	/**
	 * 初始化重试次数
	 *  retryCount
	 */
	public void initRetryCount(int retryCount) {
		super.setRetryCount(retryCount);
	}

	public Object getTask() {
		return task;
	}

	public void setTask(Object task) {
		this.task = task;
	}

	public Throwable getE() {
		return e;
	}

	public void setE(Throwable e) {
		this.e = e;
	}
	
}
