package com.alibaba.dts.client.executor.script;

import java.io.InputStream;
import java.util.concurrent.CountDownLatch;

import com.alibaba.dts.client.executor.logcollector.StreamType;



/**
 *
 * @author xiaomeng.hxm
 */
public class ShellStreamProcessor extends Thread {
    private ShellJobProcessor shellJob;
    private InputStream inputStream;
    private StreamType type;
    private CountDownLatch countDownLatch;

    public ShellStreamProcessor(ShellJobProcessor job, InputStream inputStream, StreamType type, CountDownLatch countDownLatch) {
        this.shellJob = job;
        this.inputStream = inputStream;
        this.type = type;
        this.countDownLatch = countDownLatch;
    }

    @Override
    public void run() {
        if (type == StreamType.STD_OUT) {
            shellJob.processStdOutputStream(inputStream);
        } else if (type == StreamType.STD_ERR) {
            shellJob.processStdErrorStream(inputStream);
        }

        countDownLatch.countDown();
    }
}
