package com.alibaba.dts.client.executor.simple.processor;

import com.alibaba.dts.client.executor.job.context.JobContextImpl;
import com.alibaba.dts.client.service.JobRunningStateManager;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.JobInstanceSnapshot;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.util.BytesUtil;

/**
 * 简单job上下文
 * @author tianyao.myc
 *
 */
public class SimpleJobContextImpl extends JobContextImpl implements Constants,SimpleJobContext {

	public SimpleJobContextImpl(){

	}

	private static final Logger logger = SchedulerXLoggerFactory.getLogger(SimpleJobContextImpl.class);

	/** 当前要处理的任务 */
	private Object task;

	//可用的机器数量
	private int availableMachineAmount;

	//当前机器编号
	private int currentMachineNumber;

	public SimpleJobContextImpl(Job job, JobInstanceSnapshot jobInstanceSnapshot, int retryCount) {
		super(job, jobInstanceSnapshot, retryCount);
	}
	
	/**
	 * 设置任务
	 *  taskSnapshot
	 */
	public void setTask(TaskSnapshot taskSnapshot) {
		if(BytesUtil.isEmpty(taskSnapshot.getBody())) {
			logger.error("[SimpleJobContext]: BytesUtil setTask bytesToObject error, body is empty"
					+ ", instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId());
			return ;
		}
		try {
			task = BytesUtil.bytesToObject(taskSnapshot.getBody());
		} catch (Throwable e) {
			logger.error("[SimpleJobContext]: BytesUtil setTask bytesToObject error" 
					+ ", instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId(), e);
		}
	}

	public void updateJobRunningStatus(String status){
		JobRunningStateManager.getManageHandler().addJobRunningState(this.jobInstanceSnapshot.getId(),status);
	}
	
	public Object getTask() {
		return task;
	}

	public int getAvailableMachineAmount() {
		return availableMachineAmount;
	}

	public void setAvailableMachineAmount(int availableMachineAmount) {
		this.availableMachineAmount = availableMachineAmount;
	}

	public int getCurrentMachineNumber() {
		return currentMachineNumber;
	}

	public void setCurrentMachineNumber(int currentMachineNumber) {
		this.currentMachineNumber = currentMachineNumber;
	}

}
