package com.alibaba.dts.client.executor.simple.processor;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.processor.ExSimpleJobProcessor;
import com.alibaba.dts.client.executor.job.processor.SimpleJobProcessor;
import com.alibaba.dts.client.executor.logcollector.AbstractLogCollector;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.result.ProcessResult;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.DtsLogger;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.taobao.eagleeye.EagleEye;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;

/**
 * 简单任务处理器
 *
 * @author tianyao.myc
 */
public class SimpleTaskProcessor extends Thread implements Constants {

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(SimpleTaskProcessor.class);

    private static final Logger executeLogger = SchedulerXLoggerFactory.getExecuteLogger();


    /**
     * 可执行任务
     */
    private ExecutableTask executableTask;

    /**
     * 状态
     */
    private int status = TASK_PROCESSOR_STATUS_STOP;

    /**
     * 简单Job执行上下文
     */
    private SimpleJobContext context;

    private SimpleJobProcessor simpleJobProcessor = null;

    private Object LOCK = new Object();

    private final ClientContextImpl clientContext;

    private Object rpcContext;

    public SimpleTaskProcessor(final ClientContextImpl clientContext, ExecutableTask executableTask) {
        this.clientContext = clientContext;
        this.executableTask = executableTask;
        super.setName(TASK_THREAD_NAME + executableTask.getJob().getId()
                + HORIZONTAL_LINE + executableTask.getJob().getJobProcessor()
                + HORIZONTAL_LINE + executableTask.getJobInstanceSnapshot().getId()
                + HORIZONTAL_LINE + executableTask.getJobInstanceSnapshot().getFireTime()
                + HORIZONTAL_LINE + executableTask.getJobInstanceSnapshot().getRetryCount());
        this.context = new SimpleJobContextImpl(executableTask.getJob(), executableTask.getJobInstanceSnapshot(),
                executableTask.getJobInstanceSnapshot().getRetryCount());

        this.context.setAvailableMachineAmount(executableTask.getAvailableMachineAmount());
        this.context.setCurrentMachineNumber(executableTask.getCurrentMachineNumber());
    }

    @Override
    public void run() {

        /** 任务开始 计数器加一 */
        this.status = TASK_PROCESSOR_STATUS_RUNNING;

        if (ENVIRONMENT_JST.equals(this.clientContext.getClientConfig().getEnvironment())) {
            DtsLogger.info(executableTask.getJob().getId(),
                    executableTask.getJobInstanceSnapshot().getId(), "task init start ...");
        }

        try {
            /** 处理器准备 */
            try {
                simpleJobProcessor = this.clientContext.getJobProcessorFactory().createAndGetSimpleJobProcessor(executableTask.getJob(), false);
            } catch (Throwable e) {
                logger.error("[SimpleTaskProcessor]: createAndGetSimpleJobProcessor error"
                        + ", jobProcessor:" + executableTask.getJob().getJobProcessor(), e);

                if (ENVIRONMENT_JST.equals(this.clientContext.getClientConfig().getEnvironment())) {
                    DtsLogger.info(executableTask.getJob().getId(),
                            executableTask.getJobInstanceSnapshot().getId(), "createAndGetSimpleJobProcessor error"
                                    + ", jobProcessor:" + executableTask.getJob().getJobProcessor(), e);
                }
            }

            if (ENVIRONMENT_JST.equals(this.clientContext.getClientConfig().getEnvironment())) {
                DtsLogger.info(executableTask.getJob().getId(),
                        executableTask.getJobInstanceSnapshot().getId(), "task execute start ...");
            }

            /** 执行任务 */
            EagleEye.setRpcContext(rpcContext);
            executeTask(this.executableTask, simpleJobProcessor);
        } catch (Throwable e) {
            logger.error("[SimpleTaskProcessor]: executeTask error"
                    + ", instanceId:" + this.executableTask.getJobInstanceSnapshot().getId(), e);
        } finally {
            this.status = TASK_PROCESSOR_STATUS_STOP;

            /** 删除处理器 */
            this.clientContext.getExecutor().getSimplePool().removeTask(this.executableTask);
            EagleEye.clearRpcContext();
        }

    }

    /**
     * 执行任务
     *
     *  executableTask
     *  simpleJobProcessor
     */
    private void executeTask(ExecutableTask executableTask, SimpleJobProcessor simpleJobProcessor) {

        TaskSnapshot taskSnapshot = executableTask.getTaskSnapshot();

        if (null == simpleJobProcessor) {

            logger.error("[SimpleTaskProcessor]: jobProcessor is null"
                    + ", please check " + executableTask.getJob().getJobProcessor());

            if (ENVIRONMENT_JST.equals(this.clientContext.getClientConfig().getEnvironment())) {
                DtsLogger.info(executableTask.getJob().getId(),
                        executableTask.getJobInstanceSnapshot().getId(), "jobProcessor is null"
                                + ", please check " + executableTask.getJob().getJobProcessor());
            }

            //失败确认
            this.clientContext.getExecutor().acknowledge(taskSnapshot, TASK_STATUS_FAILURE, 0);
            return;
        }

        /** 设置任务 */
        this.context.setTask(taskSnapshot);

        ProcessResult processResult = null;
        AbstractLogCollector logCollector = context.getLogCollector();
        try {
            EagleEye.startLocal(simpleJobProcessor.getClass().getName(), "process");

            if (simpleJobProcessor instanceof Advised){

                if (((Advised) simpleJobProcessor).getTargetSource().getTarget() instanceof ExSimpleJobProcessor ) {
                    ((ExSimpleJobProcessor) ((Advised) simpleJobProcessor).getTargetSource().getTarget()).preProcess(context);
                    logger.info("[SimpleTaskProcessor] instanceId=" + executableTask.getJobInstanceSnapshot().getId() + " preProcess finished.");
                }

            }else{
                if (simpleJobProcessor instanceof ExSimpleJobProcessor) {
                    ((ExSimpleJobProcessor) simpleJobProcessor).preProcess(context);
                    logger.info("[SimpleTaskProcessor] instanceId=" + executableTask.getJobInstanceSnapshot().getId() + " preProcess finished.");
                }
            }

            processResult = simpleJobProcessor.process(this.context);
            logger.info("[SimpleTaskProcessor] instanceId=" + executableTask.getJobInstanceSnapshot().getId() + " process finished.");
        } catch (Exception e) {
            logCollector.collectStderr(e.getMessage());
            logger.error("[SimpleTaskProcessor]: process error"
                    + ", instanceId:" + executableTask.getJobInstanceSnapshot().getId(), e);
        } finally {

            if (simpleJobProcessor instanceof Advised){

                try {
                    if (((Advised) simpleJobProcessor).getTargetSource().getTarget() instanceof ExSimpleJobProcessor ) {
                        ((ExSimpleJobProcessor)  ((Advised) simpleJobProcessor).getTargetSource().getTarget()).postProcess(context);
                        logger.info("[SimpleTaskProcessor] instanceId=" + executableTask.getJobInstanceSnapshot().getId() + " postProcess finished.");
                    }
                }catch (Exception e){
                    logger.error("[SimpleTaskProcessor]: postProcess error"
                            + ", instanceId:" + executableTask.getJobInstanceSnapshot().getId(), e);
                }

            }else {

                if (simpleJobProcessor instanceof ExSimpleJobProcessor) {
                    ((ExSimpleJobProcessor) simpleJobProcessor).postProcess(context);
                    logger.info("[SimpleTaskProcessor] instanceId=" + executableTask.getJobInstanceSnapshot().getId() + " postProcess finished.");
                }

            }



            String bizResultCode = "00";
            String appendMsg = "";
            if (processResult == null) {
                bizResultCode = "01";
                appendMsg = "processResult is NULL, error occurred!";
            } else {
                appendMsg = processResult.toString();
            }
            EagleEye.attribute("processResult", appendMsg);
            EagleEye.endLocal(bizResultCode, appendMsg);
        }

        if (null == processResult) {
            logger.error("[SimpleTaskProcessor]: process error, processResult is null"
                    + ", instanceId:" + executableTask.getJobInstanceSnapshot().getId());
            processResult = new ProcessResult(false);
        }

        /** ACK确认 执行结果 */
        handleRetryCount(taskSnapshot, processResult);

        int taskStatus;
        synchronized (LOCK) {
            if (this.context.isStop()) {
                taskStatus = TASK_STATUS_KILLED;
            } else {
                taskStatus = processResult.isSuccess() ? TASK_STATUS_SUCCESS : TASK_STATUS_FAILURE;
            }
        }
        this.clientContext.getExecutor().acknowledge(taskSnapshot, taskStatus, processResult.getRetryCount());

        if (ENVIRONMENT_JST.equals(this.clientContext.getClientConfig().getEnvironment())) {
            DtsLogger.info(executableTask.getJob().getId(),
                    executableTask.getJobInstanceSnapshot().getId(), "task execute end, processResult:" + processResult);
        }
    }

    /**
     * 处理重试次数
     *
     *  taskSnapshot
     *  processResult
     */
    private void handleRetryCount(TaskSnapshot taskSnapshot, ProcessResult processResult) {

        /** 如果是执行成功就不设置重试 */
        if (processResult.isSuccess()) {
            processResult.setRetryCount(0);
            return;
        }

        /** 如果是补偿任务就重试次数减一 */
        if (this.executableTask.isCompensation()) {
            if (taskSnapshot.getRetryCount() > 0) {
                processResult.setRetryCount(taskSnapshot.getRetryCount() - 1);
            } else {
                processResult.setRetryCount(0);
            }
            return;
        }

        /** 不能超过最大重试次数 */
        if (processResult.getRetryCount() > MAX_RETRY_COUNT) {
            processResult.setRetryCount(MAX_RETRY_COUNT);
            return;
        }
    }

    public int getStatus() {
        return status;
    }

    public void kill() {

        try{
            if (simpleJobProcessor != null) {
                synchronized (LOCK) {
                    if (simpleJobProcessor instanceof Advised){

                        if (((Advised) simpleJobProcessor).getTargetSource().getTarget() instanceof ExSimpleJobProcessor) {
                            if (((ExSimpleJobProcessor)  ((Advised) simpleJobProcessor).getTargetSource().getTarget()).kill()) {
                                this.context.setStop(true);
                            }
                        }

                    }else{
                        if (simpleJobProcessor instanceof ExSimpleJobProcessor) {
                            if (((ExSimpleJobProcessor) simpleJobProcessor).kill()) {
                                this.context.setStop(true);
                            }
                        }
                    }

                }
            }
        }catch (Exception e){
            logger.error("[SimpleTaskProcessor]: kill error"
                    + ", instanceId:" + executableTask.getJobInstanceSnapshot().getId(), e);
        }

    }

    public Object getRpcContext() {
        return rpcContext;
    }

    public void setRpcContext(Object rpcContext) {
        this.rpcContext = rpcContext;
    }
}
