package com.alibaba.dts.client.executor.stop;

import java.util.concurrent.*;


import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.processor.StopJobProcessor;
import com.alibaba.dts.client.executor.stop.processor.StopTaskProcessor;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;

/**
 * 终止job
 * @author tianyao.myc
 *
 */
public class StopJob implements Constants {

	private static final Logger logger = SchedulerXLoggerFactory.getLogger(StopJob.class);

	/** 指令队列 */
	private BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
	
	/** 消息消费线程池 */
	private ThreadPoolExecutor executor = null;
	
	private final ClientContextImpl clientContext;
	
	public StopJob(final ClientContextImpl clientContext) {
		this.clientContext = clientContext;
		
		this.executor = new ThreadPoolExecutor(0, 30, 
				30 * 1000L, TimeUnit.MILLISECONDS, this.queue, new ThreadFactory(){

			int index = 0;
			
			public Thread newThread(Runnable runnable) {
				index ++;
				return new Thread(runnable, "DTS-StopJobProcessor-" + index);
			}
			
		});
		
	}
	
	/**
	 * 停止任务
	 *  jobId
	 *  jobInstanceId
	 */
	public void stopTask(long jobId, long jobInstanceId) {
		
		StopJobProcessor stopJobProcessor = this.clientContext.getClientConfig().getStopJobProcessor();
		if(null == stopJobProcessor) {
			return ;
		}
		
		try {
			this.executor.execute(new StopTaskProcessor(jobId, jobInstanceId, stopJobProcessor));
		} catch (Throwable e) {
			logger.error("[StopJob]: execute error"
					+ ", jobId:" + jobId 
					+ ", jobInstanceId:" + jobInstanceId, e);
		}
		
	}
	
}
