package com.alibaba.dts.client.logger;

import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

import com.alibaba.dts.client.logger.timer.CleanLogTimer;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.DtsLogger;


public class ExecuteLogger {


	private ScheduledExecutorService executorService = Executors
			.newScheduledThreadPool(1, new ThreadFactory() {
				
				public Thread newThread(Runnable runnable) {
					return new Thread(runnable, "DTS-Clean-Log-thread");
				}
				
			});
	

	public void init() throws InitException {

		//初始化清除日志定时器
		initCleanLogTimer();
	}


	public void initCleanLogTimer() throws InitException {
		try {
			executorService.scheduleAtFixedRate(new CleanLogTimer(),
					0L, 5 * 60 * 1000L, TimeUnit.MILLISECONDS);
		} catch (Throwable e) {
			throw new InitException("[ExecuteLogger]: initCleanLogTimer error", e);
		}
	}
	

	public List<String> readLog(long jobId, long instanceId) {
		return DtsLogger.read(jobId, instanceId);
	}
	
}
