package com.alibaba.dts.client.remoting.timer;

import java.util.List;
import java.util.TimerTask;

import org.springframework.util.CollectionUtils;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;

/**
 * 心跳定时器
 * @author tianyao.myc
 *
 */
public class DtsClientHeartBeatTimer extends TimerTask {

	private static final Logger logger = SchedulerXLoggerFactory.getLogger(DtsClientHeartBeatTimer.class);

	private final ClientContextImpl clientContext;

	public DtsClientHeartBeatTimer(final ClientContextImpl clientContext) {
		this.clientContext = clientContext;
	}

	@Override
	public void run() {
		try {

			List<String> serverList = this.clientContext.getZookeeper().getServerList();
//			List<String> serverList = this.clientContext.getZookeeper().getSystemServerList();

			if(CollectionUtils.isEmpty(serverList)) {
				logger.error("[DtsClientHeartBeatTimer]: serverList is empty, clientConfig:" + this.clientContext.getClientConfig().toString());
				return ;
			}

			/** 更新服务端地址列表缓存 */
			this.clientContext.getClientRemoting().setServerListCache(serverList);
//			this.clientContext.getClientRemoting().setSystemServerListCache(serverList);

			for(String server : serverList) {

				try {
					this.clientContext.getClientRemoting().connectServer(server);
				} catch (Throwable e) {
					logger.error("[DtsClientHeartBeatTimer]: connectServer error"
							+ ", server:" + server
							+ ", clientConfig:" + this.clientContext.getClientConfig().toString(), e);
				}
			}
		} catch (Throwable e) {
			logger.error("[DtsClientHeartBeatTimer]: run error, clientConfig:" + this.clientContext.getClientConfig().toString(), e);
		}
	}

}
