package com.alibaba.dts.client.remoting.timer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.springframework.util.CollectionUtils;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.context.InvocationContext;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.service.ServerSystemService;
import com.alibaba.dts.common.util.NamedThreadFactory;

/**
 * Created by yif on 2016/12/15.
 */
public class NodeSnifferTimer implements Runnable {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(NodeSnifferTimer.class);

    private final ClientContextImpl clientContext;

    private final ServerSystemService serverSystemService;

    private ExecutorService snifferThreadPool = Executors.newFixedThreadPool(10, new NamedThreadFactory("SchedulerX-Node-Sniffer-Thread-"));

    public NodeSnifferTimer(final ClientContextImpl clientContext) {
        this.clientContext = clientContext;
        serverSystemService = clientContext.getClientRemoting().getServerSystemService();
    }

    @Override
    public void run() {

        try {

            List<String> serverList = this.clientContext.getZookeeper().getServerList();
//            List<String> serverList = this.clientContext.getZookeeper().getSystemServerList();

            if (CollectionUtils.isEmpty(serverList)) {
                logger.warn("serverList is empty, clientConfig:" + this.clientContext.getClientConfig().toString());
                return;
            }

            /** 更新服务端地址列表缓存 */
            this.clientContext.getClientRemoting().setServerListCache(serverList);
//            this.clientContext.getClientRemoting().setSystemServerListCache(serverList);
            List<RemoteMachine> remoteNodes = new ArrayList<RemoteMachine>();
            for (String server : serverList) {
                InvocationContext.setRemoteMachine(new RemoteMachine(server));
                remoteNodes = serverSystemService.getRemoteMachines(clientContext.getClientConfig().getGroupId(), 0);
                if (remoteNodes == null || remoteNodes.size() == 0) {
                    continue;
                }
                break;
            }


            if (remoteNodes.size() <= 0) {
                return;
            }
            final CountDownLatch latch = new CountDownLatch(remoteNodes.size());
            for (final RemoteMachine remoteMachine : remoteNodes) {
                snifferThreadPool.submit(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            String remoteIp = remoteMachine.getRemoteAddress().substring(0, remoteMachine.getRemoteAddress().indexOf(":"));
                            remoteMachine.setRemoteAddress(remoteIp + ":" + remoteMachine.getNodeListenPort());
                            remoteMachine.setSystemRemoteAddress(remoteIp + ":" + remoteMachine.getNodeSystemListenPort());
                            clientContext.getNodeRemoting().sniffer(remoteMachine);
                        } catch (Throwable throwable) {
                            logger.error("sniffer remote node error : " + remoteMachine);
                        } finally {
                            latch.countDown();
                        }

                    }
                });
            }
            latch.await();
        } catch (Throwable e) {
            logger.error("[NodeSnifferTimer]: run error, clientConfig:" + this.clientContext.getClientConfig().toString(), e);
        }
    }
}
