package com.alibaba.dts.client.security;


import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.taobao.spas.sdk.client.SpasSdkClientFacade;
import com.taobao.spas.sdk.client.identity.Credentials;
import com.taobao.spas.sdk.common.sign.SpasSigner;


/**
 * Created by yanshan.sy on 2016/5/4.
 */
public class SdkSecurityCheck implements Constants {

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(SdkSecurityCheck.class);

    private static Credentials credentials= SpasSdkClientFacade.getCredential();


    private String accessKey;

    private String secretKey;

    public SdkSecurityCheck() {

    }

    public String getAccessKey() {
        return accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void init() throws InitException {
        if (credentials.getAccessKey()==null || credentials.getSecretKey()==null){
            throw new InitException("[SdkSecurityCheck]: AK or SK is Null!");
        }else{

            setAccessKey(credentials.getAccessKey());

            setSecretKey(credentials.getSecretKey());

        }
    }



    public String getSignatureStr(long connectTime,String groupid){


            if (credentials.getAccessKey()==null || credentials.getSecretKey()==null){
                return "Invalid AKSK";
            }

            String signdata = groupid + connectTime;
            String sign = SpasSigner.sign(signdata, credentials.getSecretKey());
            return sign;
    }

}
