package com.alibaba.dts.client.service;

import java.io.*;
import java.util.ArrayList;
import java.util.Date;

/**
 * Created by yanshan.sy on 2016/3/22.
 */
public class JobRunningException {
    private Throwable throwable;
    private Date updateTime;

    public JobRunningException(Throwable throwable, Date updateTime){
        this.throwable = throwable;
        this.updateTime = updateTime;
    }

    public Throwable getThrowable() {
        return throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    @Override
    public String toString() {
        return "JobRunningState{" +
                "Throwable='" + throwable.getMessage() + '\'' +
                ", updateTime=" + updateTime +
                '}';
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public String[] getThrowableStrRep() {
        if (throwable == null) {
            return new String[0];
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.flush();
        LineNumberReader reader = new LineNumberReader(new StringReader(
                sw.toString()));
        ArrayList lines = new ArrayList();
        try {
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                line = reader.readLine();
            }
        } catch (IOException ex) {
            lines.add(ex.toString());
        }
        String[] rep = new String[lines.size()];
        lines.toArray(rep);
        return rep;
    }
}
