package com.alibaba.dts.client.store;


import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.store.access.CommonDao;
import com.alibaba.dts.client.store.access.ExecutionCounterDao;
import com.alibaba.dts.client.store.access.TaskSnapshotAccess;
import com.alibaba.dts.client.store.access.impl.CommonDaoH2;
import com.alibaba.dts.client.store.access.impl.ExecutionCounterDaoH2;
import com.alibaba.dts.client.store.access.impl.TaskSnapshotDaoH2;
import com.alibaba.dts.client.store.datasource.SchedulerXClientDataSource;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;


/**
 * 存储
 *
 * @author tianyao.myc
 */
public class Store {

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(Store.class);

    /**
     * 数据源
     */
    private final SchedulerXClientDataSource dataSource = new SchedulerXClientDataSource();


    private ExecutionCounterDao executionCounterDao = new ExecutionCounterDaoH2(dataSource.getDataSource());

    private TaskSnapshotAccess taskSnapshotDao = new TaskSnapshotDaoH2(dataSource.getDataSource());
    private CommonDao commonDao = new CommonDaoH2(dataSource.getDataSource());

    private ClientContextImpl clientContext;

    public Store(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    /**
     * 初始化
     *
     *  com.alibaba.tmq.common.exception.InitException
     */
    public void init() throws InitException {

        /** 数据源初始化 */
        this.dataSource.init(clientContext);


        int result = 0;
        try {

            taskSnapshotDao.createTaskSnapshotTable();
            //taskSnapshotDao.createIndex("CREATE INDEX idx_jobInstanceId ON dts_task_snapshot(job_instance_id)");
            executionCounterDao.createExecutionCounterTable();
            commonDao.createHealthCheckTable();
        } catch (Throwable e) {
            throw new InitException("[Store]: init db error", e);
        }

        logger.info("[Store]: createTaskSnapshotTable, result:" + result);

    }


    public SchedulerXClientDataSource getDataSource() {
        return dataSource;
    }

    public TaskSnapshotAccess getTaskSnapshotDao() {
        return taskSnapshotDao;
    }

    public ExecutionCounterDao getExecutionCounterDao() {
        return executionCounterDao;
    }

    public CommonDao getCommonDao() {
        return commonDao;
    }
}
