package com.alibaba.dts.client.store.access;

import java.util.List;

import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.exception.AccessException;

/**
 * Created by yanshan.sy on 2016/10/16.
 */
public interface TaskSnapshotAccess {


    public int insertBatch(List<TaskSnapshot> snapshots) throws AccessException;


    public void updateStatusBatch(List<TaskSnapshot> snapshotList, int status) throws AccessException;


    public int delete(TaskSnapshot taskSnapshot) throws AccessException;



    int createTaskSnapshotTable() throws AccessException;

    int taskSnapshotAck(TaskSnapshot taskSnapshot) throws AccessException;


    void deleteFinishedTasks() throws AccessException;

    void updateReceiveNodeBatch(List<TaskSnapshot> taskSnapshotList, String receiveNode) throws AccessException;

    void updateStatus2QueueIfStatusIsInitBatch(List<TaskSnapshot> taskSnapshotList) throws AccessException;


    long queryUnFinishedTasksCount(long jobInstanceId) throws AccessException;

    long queryUnFinishedTasksCountForDelete(long jobInstanceId) throws AccessException;


    List<TaskSnapshot> listTaskSnapshotsFromStartId(long start, int limit) throws AccessException;

    long deleteByJobInstanceId(long jobInstanceId) throws AccessException;

    long deleteByReceiveNodeAddressAndStatus(String receiveNodeAddress, int status) throws AccessException;

    List<TaskSnapshot> listByIdAndReceiveNodeAndStatus(long id, String receiveNodeAddress, int status)
        throws AccessException;

    long queryTotalCount() throws AccessException;

    int queryTaskCountByJobInstanceId(long jobInstanceId, int status) throws AccessException;

    int createIndex(String sql) throws AccessException;
}
