package com.alibaba.dts.client.store.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.store.StoreStrategy;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.util.PathUtil;


/**
 * 数据源
 *
 * @author tianyao.myc
 */
public class SchedulerXClientDataSource implements Constants {

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(SchedulerXClientDataSource.class);

    private String dbUrl;

    private final DruidDataSource dataSource = new DruidDataSource();

    /**
     * 初始化
     *
     *  com.alibaba.tmq.common.exception.InitException
     */
    @SuppressWarnings("deprecation")
    public void init(ClientContextImpl clientContext) throws InitException {

        if (clientContext.getNodeConfig().getStoreStrategy() == StoreStrategy.DISK) {
            dbUrl = "jdbc:h2:file:" + clientContext.getNodeConfig().getDbPath() + "schedulerx;CACHE_SIZE=1000;AUTO_SERVER=TRUE;MODE=MySQL;DB_CLOSE_ON_EXIT=FALSE";
        } else if (clientContext.getNodeConfig().getStoreStrategy() == StoreStrategy.MEMORY) {
            dbUrl = "jdbc:h2:mem:schedulerx";
        } else {
            throw new InitException("unable to find correct storeStrategy, the current storeStrategy is " + clientContext.getNodeConfig().getStoreStrategy());
        }

        dataSource.setUrl(dbUrl);
        dataSource.setDriverClassName("org.h2.Driver");
        dataSource.setUsername("sa");
        dataSource.setPassword("");
        dataSource.setInitialSize(4);
        dataSource.setMinIdle(4);
        dataSource.setMaxActive(32);

        dropDB(dataSource);
    }

    private void dropDB(DruidDataSource dataSource) throws InitException {
        long result = 0;
        try {
            result = dataSource.getConnection().prepareStatement("DROP DATABASE IF EXISTS schedulerx").executeUpdate();
        } catch (Throwable throwable) {
            logger.error("drop db error", throwable);
            throw new InitException(throwable);
        }
    }


    public DruidDataSource getDataSource() {
        return dataSource;
    }


}
