package com.alibaba.dts.sdk;

import java.util.Arrays;
import java.util.List;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.domain.store.Cluster;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.assemble.*;
import com.alibaba.dts.sdk.context.SDKContext;
import com.alibaba.dts.sdk.util.CookieUtil;


public class DtsSimpleSDKManager extends DtsCommonSDKManager {

    public Result<Boolean> initDtsService(HttpServletRequest request) {
        initCookie(request);
        Result<Boolean> result = new Result<Boolean>();
        Result<List<Cluster>> clusterResult = getDtsClustersInfo();
        if(clusterResult.getResultCode() == ResultCode.SUCCESS) {
            List<Cluster> clusters = clusterResult.getData();
            for(Cluster cluster: clusters) {
                createGroup(cluster.getId(), Constants.DEFAULT_GROUP_NAME);
            }
        } else {
            result.setResultCode(clusterResult.getResultCode());
        }
        return result;
    }

    public Result<List<Cluster>> getDtsClustersInfo(HttpServletRequest request) {
        initCookie(request);
        return super.getDtsClustersInfo();
    }

    public Result<String> createGroup(HttpServletRequest request, long clusterId, String groupDescription) {
        initCookie(request);
        return super.createGroup(clusterId, groupDescription);
    }

    public Result<Boolean> deleteGroup(HttpServletRequest request, String userGroupId) {
        initCookie(request);
        return super.deleteGroup(userGroupId);
    }

    public Result<List<AssembledUserGroup>> getUserGroups(HttpServletRequest request, long clusterId) {
        initCookie(request);
        return super.getUserGroups(clusterId);
    }

    public Result<Long> createJob(HttpServletRequest request, String userGroupId, Job job) {
        initCookie(request);
        return super.createJob(userGroupId, job);
    }

    public Result<Integer> deleteJob(HttpServletRequest request, long jobId) {
        initCookie(request);
        return super.deleteJob(jobId);
    }

    public Result<Integer> updateJob(HttpServletRequest request, String groupId, Job job) {
        initCookie(request);
        return super.updateJob(groupId, job);
    }

    public Result<Integer> updateJobWithArguments(HttpServletRequest request, String groupId, Job job) {
        initCookie(request);
        return super.updateJobWithArguments(groupId, job);
    }


    public Result<Integer> updateJobArguments(HttpServletRequest request, long jobId, String jobArguments) {
        initCookie(request);
        return super.updateJobArguments(jobId, jobArguments);
    }

    public Result<List<Job>> getJobsForGroup(HttpServletRequest request, String userGroupId) {
        initCookie(request);
        return super.getJobsForGroup(userGroupId);
    }

    public Result<Boolean> enableJob(HttpServletRequest request, long jobId) {
        initCookie(request);
        return super.enableJob(jobId);
    }

    public Result<Boolean> disableJob(HttpServletRequest request, long jobId) {
        initCookie(request);
        return super.disableJob(jobId);
    }

    public Result<Boolean> instanceRunJob(HttpServletRequest request, String userGroupId, long jobId) {
        initCookie(request);
        return super.instanceRunJob(userGroupId, jobId);
    }

    public Result<Boolean> instanceStopJob(HttpServletRequest request, long jobId) {
        initCookie(request);
        return super.instanceStopJob(jobId);
    }

    public Result<Boolean> setJobMonitorConfig(HttpServletRequest request, AssembledMonitor monitorSeting) {
        initCookie(request);
        return super.setJobMonitorConfig(monitorSeting);
    }

    public Result<Boolean> updateJobMonitor(HttpServletRequest request, AssembledMonitor monitorSeting) {
        initCookie(request);
        return super.updateJobMonitor(monitorSeting);
    }

    public Result<AssembledMonitor> getMonitorSetings(HttpServletRequest request, long jobId) {
        initCookie(request);
        return super.getMonitorSetings(jobId);
    }

    public Result<JobStatus> getJobRunningStatus(HttpServletRequest request, long jobId) {
        initCookie(request);
        return super.getJobRunningStatus(jobId);
    }

    public Result<JobInstanceDetailStatus> getJobDetailRunningStatus(HttpServletRequest request, long jobId, long instanceId) {
        initCookie(request);
        return super.getJobDetailRunningStatus(jobId, instanceId);
    }

    public Result<Boolean> grantGroupAuth(HttpServletRequest request, String userGroupId, String ownerUserId, String grantUserId) {
        initCookie(request);
        return super.grantGroupAuth(userGroupId, ownerUserId, grantUserId);
    }

    public Result<JobExecuteHistory> getJobRunningHistoryStatus(HttpServletRequest request, long jobId) {
        initCookie(request);
        return super.getJobRunningHistoryStatus(jobId);
    }

    private void initCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        SDKContext.setCookie(CookieUtil.cookieToString( Arrays.asList(cookies)));
    }

}
