package com.alibaba.dts.sdk.client;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.sdk.util.HttpUtil;

/**
 * Http 客户端;
 * Created by luliang on 14/12/29.
 */
public class DtsHttpClient {

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(DtsHttpClient.class);

    private String domainUrl;

    private static final String ACTION_NAME = "SDKAction";

//    private String target;
    
    private ThreadLocal<String> targetThreadLocal = new ThreadLocal<String>();

//    private String submitAction;
    
    private ThreadLocal<String> submitActionThreadLocal = new ThreadLocal<String>();

    //请求参数;
//    private ConcurrentHashMap<String, String> parameterMap = new ConcurrentHashMap<String, String>();
    
    private ThreadLocal<ConcurrentHashMap<String, String>> parameterMapThreadLocal = new ThreadLocal<ConcurrentHashMap<String, String>>();

    public DtsHttpClient() {
    }
    
    public DtsHttpClient(String domainUrl) {
    	this.domainUrl = domainUrl;
    }

    public String doPost() {
        String requestURL = domainUrl;
        requestURL += "/" + targetThreadLocal.get() /**target*/ + "?";
        requestURL += "action=" + ACTION_NAME + "&";
        requestURL += submitActionThreadLocal.get() /**submitAction*/ + "=1";
        String data = parseParameter(requestURL);
        String result = null;
        try {
            result = HttpUtil.sendRequest(requestURL, data);
        } catch (Throwable e) {
            logger.error("[DtsHttpClient]: doPost, requestURL:" + requestURL + ", data:" + data, e);
        }
        logger.info("[DtsHttpClient]: doPost, requestURL:" + requestURL + ", data:" + data + ", result:" + result);
        return result;
    }

    public String doPost(String url, HashMap<String, String> params) {
        String result = null;
        String data = parseParameter(params);
        try {
            result = HttpUtil.sendRequest(url, data);
        } catch (Throwable e) {
            logger.error("[DtsHttpClient]: doPost, requestURL:" + url + ", data:" + data, e);
        }
        logger.info("[DtsHttpClient]: doPost, requestURL:" + url + ", data:" + data + ", result:" + result);
        return result;
    }

    public String getDomainUrl() {
        return domainUrl;
    }

    public void setDomainUrl(String domainUrl) {
        this.domainUrl = domainUrl;
    }

    public DtsHttpClient addParameter(String name, String value) {
//        parameterMap.put(name, value);
    	ConcurrentHashMap<String, String> map = parameterMapThreadLocal.get();
    	if(null == map) {
    		map = new ConcurrentHashMap<String, String>();
    		parameterMapThreadLocal.set(map);
    	}
    	map.put(name, value);
        return this;
    }

    public DtsHttpClient setTarget(String target) {
//        this.target = target;
        targetThreadLocal.set(target);
        return this;
    }

    private String parseParameter(String url) {
        StringBuilder sb = new StringBuilder();
        
        ConcurrentHashMap<String, String> map = parameterMapThreadLocal.get();
        if(null == map || map.isEmpty()) {
            return sb.toString();
        }
        
        for (Map.Entry<String, String> entry : /**parameterMap*/ map.entrySet()) {
            sb.append("&").append(entry.getKey()).append("=").append(entry.getValue());
//            try {
//                sb.append("&").append(entry.getKey()).append("=").append(new String(entry.getValue().getBytes("UTF-8")));
//            } catch (UnsupportedEncodingException e) {
//
//            }
//            try {
//                sb.append("&").append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8"));
//            } catch (UnsupportedEncodingException e) {
//
//            }
        }
//        parameterMap.clear();
        parameterMapThreadLocal.get().clear();
        return sb.toString();
    }

    private String parseParameter(Map<String, String > params) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sb.append("&").append(entry.getKey()).append("=").append(entry.getValue() == null? "" : entry.getValue());
        }
        return sb.toString();
    }

    public DtsHttpClient setSubmitAction(String submitAction) {
//        this.submitAction = submitAction;
        submitActionThreadLocal.set(submitAction);
        return this;
    }
}
