package com.alibaba.edas.schedulerx;

import com.alibaba.dts.client.SchedulerxClient;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;

import java.util.Arrays;

/**
 * Created by yanshan.sy on 2016/4/13.
 */
//public class SchedulerXClient  extends DtsClient {
public class SchedulerXClient  extends SchedulerxClient {

    private static final Logger logger = SchedulerXLoggerFactory.getLogger(SchedulerXClient.class);

    public void init() throws InitException {
        this.setEnvironment(Constants.ENVIRONMENT_SCX);
        super.init();
    }

    /**
     * SchedulerX-Agent程序启动入口
     *
     *  arguments
     */
    public static void main(String[] arguments) {

        SchedulerXClient schedulerXClient = new SchedulerXClient();//创建DtsClient
        //设置SchedulerX-Agent方式启动
        schedulerXClient.getClientContext().getClientConfig().setAgent(true);

        /** 设置INI配置文件路径 */
        schedulerXClient.getClientContext().getClientConfig().setConfigPath(arguments[0]);

        try {
            schedulerXClient.init();//初始化DtsClient
        } catch (Throwable e) {


            logger.error("[SchedulerX-Agent]: main init error"
                    + ", clientConfig:" + schedulerXClient.getClientContext().getClientConfig()
                    + ", arguments:" + Arrays.toString(arguments), e);

            //启动失败退出进程
            System.exit(0);
        }

        logger.warn("[SchedulerX-Agent]: main init over"
                + ", clientConfig:" + schedulerXClient.getClientContext().getClientConfig()
                + ", arguments:" + Arrays.toString(arguments));
    }
}
