package com.alibaba.tmq.client.monitor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.alibaba.tmq.client.context.ClientContext;
import com.alibaba.tmq.common.exception.InitException;
import com.alibaba.tmq.common.monitor.MethodMonitor;
import com.alibaba.tmq.common.monitor.callback.Display;

/**
 * 客户端监控
 * @author tianyao.myc
 *
 */
public class ClientMonitor {

	private static final Log logger = LogFactory.getLog(ClientMonitor.class);
	
	//方法监控
	private final MethodMonitor methodMonitor = new MethodMonitor(logger);
	
	/**
	 * 初始化
	 *  InitException
	 */
	public void init() throws InitException {
		
		//初始化方法监控
		if(ClientContext.clientConfig.isOpenMonitor()) {
			this.methodMonitor.init();
		}
		
	}
	
	/**
	 * 添加展现
	 *  display
	 */
	public void addDisplay(Display display) {
		
		if(ClientContext.clientConfig.isOpenMonitor()) {
			this.methodMonitor.addDisplay(display);
		}
		
	}
	
	/**
	 * 方法统计
	 *  key
	 *  startTime
	 */
	public void methodCount(String key, long startTime) {
		
		if(ClientContext.clientConfig.isOpenMonitor()) {
			this.methodMonitor.methodCount(key, startTime);
		}
		
	}
	
}
