package com.alibaba.tmq.client.remoting.processor;

import java.util.concurrent.LinkedBlockingQueue;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.alibaba.tmq.client.context.ClientContext;
import com.alibaba.tmq.common.context.InvocationContext;
import com.alibaba.tmq.common.domain.remoting.protocol.InvokeMethod;
import com.alibaba.tmq.common.domain.result.ResultCode;
import com.alibaba.tmq.common.exception.InitException;
import com.alibaba.tmq.common.helper.RemotingHelper;
import com.alibaba.tmq.common.monitor.callback.Display;
import com.alibaba.tmq.common.remoting.netty.NettyRequestProcessor;
import com.alibaba.tmq.common.remoting.protocol.RemotingCommand;
import com.alibaba.tmq.common.util.BytesUtil;
import io.netty.channel.ChannelHandlerContext;

/**
 * 客户端请求处理器
 * @author tianyao.myc
 *
 */
public class ClientRequestProcessor extends ClientContext implements NettyRequestProcessor {

	private static final Log logger = LogFactory.getLog(ClientRequestProcessor.class);
	
	/** 请求队列 */
	private LinkedBlockingQueue<Runnable> requestQueue = null;
	
	public ClientRequestProcessor(LinkedBlockingQueue<Runnable> requestQueue) {
		this.requestQueue = requestQueue;
	}
	
	/**
	 * 初始化
	 *  InitException
	 */
	public void init() throws InitException {
		
		//添加展现
		clientMonitor.addDisplay(new Display(){
			
			public String content() {
				
				return "requestQueue > size:" + requestQueue.size() + ", remainingCapacity:" + requestQueue.remainingCapacity();
			}
			
		});
		
	}
	
	/**
	 * 处理请求
	 */
	public RemotingCommand processRequest(ChannelHandlerContext ctx,
			RemotingCommand request) throws Exception {
		
		long startTime = System.currentTimeMillis();
		
		byte[] requestBody = request.getBody();
		if(null == requestBody) {
			final String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
			logger.error("[ClientRequestProcessor]: requestBody is null, remoteAddress:" + remoteAddress);
			return new RemotingCommand();
		}
		
		InvokeMethod invokeMethod = null;
		try {
			invokeMethod = (InvokeMethod)BytesUtil.bytesToObject(requestBody);
		} catch (Throwable e) {
			final String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
			logger.error("[ClientRequestProcessor]: bytesToObject error"
					+ ", remoteAddress:" + remoteAddress, e);
			return new RemotingCommand();
		}
		
		if(null == invokeMethod) {
			final String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
			logger.error("[ClientRequestProcessor]: invokeMethod is null"
					+ ", remoteAddress:" + remoteAddress);
			return new RemotingCommand();
		}
		
		invokeMethod.reversal();//信息反转
		invokeMethod.getConnectionChannel().setChannel(ctx.channel());
		
		/** 设置上下文 */
		InvocationContext.setConnectionChannel(invokeMethod.getConnectionChannel());
		Object result = (Object)proxyService.invokeMethod(clientService, invokeMethod.getMethodName(), 
				invokeMethod.getParameterTypes(), invokeMethod.getArguments());
		/** 清除上下文 */
		InvocationContext.clean();
		
		if(null == result) {
			final String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
			logger.error("[ClientRequestProcessor]: result is null, remoteAddress:" + remoteAddress + ", invokeMethod:" + invokeMethod);
			return new RemotingCommand();
		}
		
		if(ResultCode.NO_SUCH_METHOD.equals(result)) {
			final String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
			logger.error("[ClientRequestProcessor]: NO_SUCH_METHOD, remoteAddress:" + remoteAddress + ", invokeMethod:" + invokeMethod);
			byte[] resultBody = null;
			try {
				resultBody = BytesUtil.objectToBytes(ResultCode.NO_SUCH_METHOD.toJsonString());
			} catch (Throwable e) {
				logger.error("[ClientRequestProcessor]: NO_SUCH_METHOD objectToBytes error"
						+ ", remoteAddress:" + remoteAddress 
						+ ", invokeMethod:" + invokeMethod, e);
			}
			RemotingCommand response = new RemotingCommand();
			response.setBody(resultBody);
			return response;
		}
		
		byte[] responseBody = null;
		try {
			responseBody = BytesUtil.objectToBytes(result);
		} catch (Throwable e) {
			final String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
			logger.error("[ClientRequestProcessor]: objectToBytes error"
					+ ", remoteAddress:" + remoteAddress + ", invokeMethod:" + invokeMethod, e);
			return new RemotingCommand();
		}
		
		RemotingCommand response = new RemotingCommand();
		response.setBody(responseBody);
		
		//方法调用统计
		clientMonitor.methodCount(invokeMethod.getMethodName(), startTime);
		
		return response;
	}
	
	

}
