package com.alibaba.tmq.client.remoting.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.alibaba.tmq.client.context.ClientContext;
import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.context.InvocationContext;
import com.alibaba.tmq.common.domain.remoting.ConnectionChannel;
import com.alibaba.tmq.common.domain.remoting.protocol.InvokeMethod;
import com.alibaba.tmq.common.remoting.protocol.RemotingCommand;
import com.alibaba.tmq.common.util.BytesUtil;
import com.alibaba.tmq.common.util.RemotingUtil;
import io.netty.channel.Channel;


/**
 * 客户端代理调用接口
 * @author tianyao.myc
 *
 */
public class ClientInvocationHandler extends ClientContext implements InvocationHandler, Constants {

	private static final Log logger = LogFactory.getLog(ClientInvocationHandler.class);
	
	/**
	 * 拦截方法调用各项参数
	 */
	public Object invoke(Object proxy, Method method, Object[] args)
			throws Throwable {
		
		ConnectionChannel connectionChannel = InvocationContext.acquireConnectionChannel();
		connectionChannel.setLocalId(clientConfig.getClientId());
		connectionChannel.setLocalVersion(clientConfig.getVersion());
        Channel channel = clientRemoting.getAndCreateChannel(connectionChannel.getRemoteAddress());
        if(null == channel) {
			if (method.getName().equals("connect")){
				logger.warn("[ClientInvocationHandler]: getAndCreateChannel error"
						+ ", server:" + connectionChannel.getRemoteAddress()
						+ ", timeout:" + connectionChannel.getTimeout()
						+ ", methodName:" + method.getName());
			}else{
				logger.error("[ClientInvocationHandler]: getAndCreateChannel error"
						+ ", server:" + connectionChannel.getRemoteAddress()
						+ ", timeout:" + connectionChannel.getTimeout()
						+ ", methodName:" + method.getName());
			}

            InvocationContext.clean();
			return null;
        }
        connectionChannel.setLocalAddress(RemotingUtil.socketAddress2String(channel.localAddress()));
        
		InvokeMethod invokeMethod = new InvokeMethod(connectionChannel, method.getName(), method.getParameterTypes(), args);
		byte[] requestBody = null;
		try {
			requestBody = BytesUtil.objectToBytes(invokeMethod);
		} catch (Throwable e) {
			logger.error("[ClientInvocationHandler]: objectToBytes error"
					+ ", server:" + connectionChannel.getRemoteAddress() 
					+ ", timeout:" + connectionChannel.getTimeout() 
					+ ", methodName:" + method.getName(), e);
            InvocationContext.clean();
			return null;
		}
		if(null == requestBody) {
			logger.error("[ClientInvocationHandler]: requestBody is null"
					+ ", server:" + connectionChannel.getRemoteAddress() 
					+ ", timeout:" + connectionChannel.getTimeout() 
					+ ", methodName:" + method.getName());
            InvocationContext.clean();
			return null;
		}
		RemotingCommand request = new RemotingCommand();
		request.setBody(requestBody);
		RemotingCommand response = null;
		try {
			response = clientRemoting.invokeSync(connectionChannel.getRemoteAddress(), request, connectionChannel.getTimeout());
		} catch (Throwable e) {
			if (method.getName().equals("connect")){
				logger.warn("[ClientInvocationHandler]: invoke error"
						+ ", server:" + connectionChannel.getRemoteAddress()
						+ ", timeout:" + connectionChannel.getTimeout()
						+ ", methodName:" + method.getName(), e);
			}else{
				logger.error("[ClientInvocationHandler]: invoke error"
						+ ", server:" + connectionChannel.getRemoteAddress()
						+ ", timeout:" + connectionChannel.getTimeout()
						+ ", methodName:" + method.getName(), e);
			}
		}
        InvocationContext.clean();
		if(null == response) {
			if (method.getName().equals("connect")){
				logger.warn("[ClientInvocationHandler]: response is null"
						+ ", server:" + connectionChannel.getRemoteAddress()
						+ ", timeout:" + connectionChannel.getTimeout()
						+ ", methodName:" + method.getName());
			}else {
				logger.error("[ClientInvocationHandler]: response is null"
						+ ", server:" + connectionChannel.getRemoteAddress()
						+ ", timeout:" + connectionChannel.getTimeout()
						+ ", methodName:" + method.getName());
			}

			return null;
		}
		
		if(void.class == method.getGenericReturnType()) {
			return null;//如果返回值是void就return null
		}
		
		byte[] responseBody = response.getBody();
		if(null == responseBody) {
			logger.error("[ClientInvocationHandler]: responseBody is null"
					+ ", server:" + connectionChannel.getRemoteAddress() 
					+ ", timeout:" + connectionChannel.getTimeout() 
					+ ", methodName:" + method.getName());
			
			return null;
		}
		
		Object object = null;
		try {
			object = (Object)BytesUtil.bytesToObject(responseBody);
		} catch (Throwable e) {
			logger.error("[ClientInvocationHandler]: bytesToObject error"
					+ ", server:" + connectionChannel.getRemoteAddress() 
					+ ", timeout:" + connectionChannel.getTimeout() 
					+ ", methodName:" + method.getName(), e);
		}
		if(null == object) {
			logger.error("[ClientInvocationHandler]: object is null"
					+ ", server:" + connectionChannel.getRemoteAddress() 
					+ ", timeout:" + connectionChannel.getTimeout() 
					+ ", methodName:" + method.getName());
			
			return null;
		}
		
		return object;
	}

}
