package com.alibaba.tmq.client.system.consumer.executer;

import java.util.concurrent.ConcurrentHashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.alibaba.tmq.client.system.consumer.Consumer;
import com.alibaba.tmq.client.system.consumer.config.ConsumerConfig;
import com.alibaba.tmq.client.system.consumer.implement.DefaultConsumer;
import com.alibaba.tmq.client.system.consumer.listener.MessageListener;
import com.alibaba.tmq.common.domain.Action;
import com.alibaba.tmq.common.domain.ConsumerKey;
import com.alibaba.tmq.common.domain.Message;
import com.alibaba.tmq.common.domain.remoting.ConnectionChannel;
import com.alibaba.tmq.common.domain.result.Result;
import com.alibaba.tmq.common.domain.result.ResultCode;
import com.taobao.eagleeye.EagleEye;

/**
 * 消费者执行器
 * @author tianyao.myc
 *
 */
public class ConsumerExecuter {

	private static final Log logger = LogFactory.getLog(ConsumerExecuter.class);
	
	/** 消费者 */
	private final Consumer consumer;
	
	/** listener映射表 */
	private final ConcurrentHashMap<ConsumerKey, MessageListener> listenerTable = new ConcurrentHashMap<ConsumerKey, MessageListener>();
	
	/** 各项参数配置 */
	private final ConsumerConfig consumerConfig;
	
	//Consumer是否启动
	private volatile boolean start = false;
	
	public ConsumerExecuter(ConsumerConfig consumerConfig, String instanceName) {
		this.consumerConfig = consumerConfig;
		this.consumer = new DefaultConsumer(this, consumerConfig);
	}
	
	/**
	 * 消费消息
	 *  consumerKey
	 *  message
	 *  connectionChannel
	 *
	 */
	public Result<Action> consume(ConsumerKey consumerKey, Message message, ConnectionChannel connectionChannel) {
		
		Result<Action> result = new Result<Action>();
		
		//获取监听器
		MessageListener messageListener = this.listenerTable.get(consumerKey);
		
		//messageListener为空就返回异常
		if(null == messageListener) {
			
			throw new RuntimeException("[ConsumerExecuter]: consume message fatal error, messageListener is null"
					+ ", message:" + message 
					+ ", consumerKey:" + consumerKey);
			
		}
		
		ConsumeContext context = new ConsumeContext();//消费上下文
		
		//设置远端地址
		context.setRemoteAddress(connectionChannel.getRemoteAddress());
		
		//设置服务器推送时间
		context.setServerPushTime(connectionChannel.getServerPushTime());

		//打入全链路压测标记
		if  (message.getTb_eagleeyex_t()!=null) {
			if (message.getTb_eagleeyex_t().equals("1")){
				EagleEye.putUserData("t", "1");
				logger.warn("[ConsumerExecuter]: set Tb_eagleeyex_t "
						+ ", message:" + message
						+ ", consumerKey:" + consumerKey);
			}
		}
		
		Action action = Action.RETRY;
		try {
			action = messageListener.consume(message, context);
		} catch (Throwable e) {
			
			logger.error("[ConsumerExecuter]: consume message error"
					+ ", message:" + message 
					+ ", consumerKey:" + consumerKey, e);
			
			result.setData(Action.RETRY);
			result.setResultCode(ResultCode.CONSUME_EXCEPTION);
			return result;
		} finally {
			try {
				EagleEye.removeUserData("t");
			} catch (Throwable e) {
				logger.error("[ConsumerExecuter]: consume removeUserData error"
						+ ", message:" + message 
						+ ", consumerKey:" + consumerKey, e);
			}
		}
		
		if(null == action) {
			logger.error("[ConsumerExecuter]: consume result action is null error"
					+ ", waiting retry"
					+ ", message:" + message 
					+ ", consumerKey:" + consumerKey);
			
			result.setData(Action.RETRY);
			result.setResultCode(ResultCode.CONSUME_RETURN_NULL_ERROR);
			return result;
		}
		
		if(Action.FAILURE.equals(action)) {
			action = Action.RETRY;
		}
		
		result.setData(action);
		result.setResultCode(ResultCode.SUCCESS);
		return result;
	}

	public Consumer getConsumer() {
		return consumer;
	}

	public ConcurrentHashMap<ConsumerKey, MessageListener> getListenerTable() {
		return listenerTable;
	}

	public boolean isStart() {
		return start;
	}

	public void setStart(boolean start) {
		this.start = start;
	}

}
