package com.alibaba.tmq.client.system.consumer.implement;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.alibaba.tmq.client.TMQFactory;
import com.alibaba.tmq.client.context.ClientContext;
import com.alibaba.tmq.client.system.consumer.Consumer;
import com.alibaba.tmq.client.system.consumer.config.ConsumerConfig;
import com.alibaba.tmq.client.system.consumer.executer.ConsumerExecuter;
import com.alibaba.tmq.client.system.consumer.listener.MessageListener;
import com.alibaba.tmq.client.util.StringUtil;
import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.domain.ConsumerKey;
import com.taobao.common.fulllinkstresstesting.SplitEnvUtil;

/**
 * 默认消费者
 * @author tianyao.myc
 *
 */
public class DefaultConsumer extends ClientContext implements Consumer, Constants {

	private static final Log logger = LogFactory.getLog(DefaultConsumer.class);
	
	/** 消费者执行器 */
	private final ConsumerExecuter consumerExecuter;
	
	/** 各项参数配置 */
	private final ConsumerConfig consumerConfig;
	
	public DefaultConsumer(ConsumerExecuter consumerExecuter, ConsumerConfig consumerConfig) {
		this.consumerExecuter = consumerExecuter;
		this.consumerConfig = consumerConfig;
	}
	
	/**
	 * 启动
	 */
	@SuppressWarnings("rawtypes")
	public void start() {
		
		if( ! SplitEnvUtil.needStartDTS()){
			logger.error("[DefaultConsumer]: start error, because of isolation environment");
			return ;
		}
		
		ConcurrentHashMap<ConsumerKey, MessageListener> listenerTable = this.consumerExecuter.getListenerTable();
		
		//如果listenerTable为空就抛出异常
		if(listenerTable.isEmpty()) {
			throw new RuntimeException("[DefaultConsumer]: start error, there is no any messageListener");
		}
		
		/** 初始化客户端 */
		try {
			initClient();
		} catch (Throwable e) {
			throw new RuntimeException("[DefaultConsumer]: start initClient error"
					+ ", clientConfig:" + clientConfig 
					+ ", consumerConfig:" + consumerConfig, e);
		}
		
		Iterator iterator = listenerTable.entrySet().iterator();
		while(iterator.hasNext()) {
			Map.Entry entry = (Map.Entry)iterator.next();
			ConsumerKey consumerKey = (ConsumerKey)entry.getKey();

			/** 初始化连接 */
			try {
				
				clientRemoting.initConnection(this.consumerConfig.getInstanceName(), 
						ROLE_TYPE_CONSUMER, this.consumerConfig.getConsumerId(), 
						consumerKey.getTopic(), consumerKey.getTag());
				
				logger.warn("[DefaultConsumer]: start initConnection"
						+ ", clientConfig:" + clientConfig 
						+ ", consumerConfig:" + consumerConfig 
						+ ", consumerKey:" + consumerKey);
			} catch (Throwable e) {
				logger.error("[DefaultConsumer]: start initConnection error"
						+ ", clientConfig:" + clientConfig 
						+ ", consumerConfig:" + consumerConfig 
						+ ", consumerKey:" + consumerKey, e);
				
				throw new RuntimeException("[DefaultConsumer]: start initConnection error"
						+ ", clientConfig:" + clientConfig 
						+ ", consumerConfig:" + consumerConfig, e);
			}
			
		}
		
		//设置Consumer状态为启动
		this.consumerExecuter.setStart(true);
		
	}

	/**
	 * 订阅消息
	 *  topic
	 *  tag
	 *  messageListener
	 */
	public void subscribe(String topic, String tag, MessageListener messageListener) {
		
		//如果topic为空就抛出异常
		if(StringUtil.isBlank(topic)) {
			throw new RuntimeException("[DefaultConsumer]: subscribe error, topic is empty");
		}
		
		//如果messageListener为空就抛出异常
		if(null == messageListener) {
			throw new RuntimeException("[DefaultConsumer]: subscribe error, messageListener is null");
		}
		
		ConcurrentHashMap<ConsumerKey, MessageListener> listenerTable = this.consumerExecuter.getListenerTable();
		
		String beforeListenerTable = listenerTable.toString();
		
		//设置消息监听器
		listenerTable.put(new ConsumerKey(this.consumerConfig.getConsumerId(), topic, tag), messageListener);
		
		logger.warn("[DefaultConsumer]: subscribe"
				+ ", consumerId:" + this.consumerConfig.getConsumerId() 
				+ ", instanceName:" + this.consumerConfig.getInstanceName() 
				+ ", topic:" + topic 
				+ ", tag:" + tag 
				+ ", beforeListenerTable:" + beforeListenerTable 
				+ ", afterListenerTable" + listenerTable);
	}

	/**
	 * 关闭
	 */
	@SuppressWarnings("rawtypes")
	public void shutdown() {

		//设置Consumer状态为停止
		this.consumerExecuter.setStart(false);
		
		/** 移除消费者 */
		TMQFactory.removeConsumer(this.consumerConfig.getConsumerId(), this.consumerConfig.getInstanceName());
		
		ConcurrentHashMap<ConsumerKey, MessageListener> listenerTable = this.consumerExecuter.getListenerTable();
		
		//如果listenerTable为空就返回
		if(listenerTable.isEmpty()) {
			return ;
		}
		
		Iterator iterator = listenerTable.entrySet().iterator();
		while(iterator.hasNext()) {
			Map.Entry entry = (Map.Entry)iterator.next();
			ConsumerKey consumerKey = (ConsumerKey)entry.getKey();

			/** 断开连接 */
			try {
				
				clientRemoting.removeConnection(this.consumerConfig.getInstanceName(), 
						ROLE_TYPE_CONSUMER, this.consumerConfig.getConsumerId(), 
						consumerKey.getTopic(), consumerKey.getTag());
				
				logger.warn("[DefaultConsumer]: shutdown removeConnection"
						+ ", clientConfig:" + clientConfig 
						+ ", consumerConfig:" + consumerConfig 
						+ ", consumerKey:" + consumerKey);
			} catch (Throwable e) {
				logger.error("[DefaultConsumer]: shutdown removeConnection error"
						+ ", clientConfig:" + clientConfig 
						+ ", consumerConfig:" + consumerConfig 
						+ ", consumerKey:" + consumerKey, e);
			}
			
		}
	}

}
