package com.alibaba.tmq.client.system.producer;

import java.util.List;

import com.alibaba.tmq.common.domain.Message;
import com.alibaba.tmq.common.domain.result.SendResult;
import com.alibaba.tmq.common.domain.result.SubmitResult;
import com.alibaba.tmq.common.domain.result.UpdateResult;
import com.alibaba.tmq.common.exception.TMQException;

/**
 * 普通生产者
 * @author tianyao.myc
 *
 */
public interface NormalProducer extends Producer {
	
	/**
	 * 提交消息
	 *  message
	 *
	 *  TMQException
	 */
	public SubmitResult submit(Message message) throws TMQException;
	
	/**
	 * 批量提交消息
	 *  messageList
	 *
	 *  TMQException
	 */
	public SubmitResult submit(List<? extends Message> messageList) throws TMQException;

	/**
	 * 发送非事物消息
	 *  message
	 *
	 *  TMQException
	 */
	public SendResult send(Message message) throws TMQException;
	
	/**
	 * 批量发送非事物消息
	 *  messageList
	 *
	 *  TMQException
	 */
	public SendResult send(List<Message> messageList) throws TMQException;
	

	/**
	 * 批量更新消息
	 *  messageList
	 *
	 *  TMQException
	 */
	public UpdateResult update(List<Message> messageList) throws TMQException;
	
}
