package com.alibaba.tmq.client.system.producer;

import java.util.List;

import com.alibaba.tmq.client.system.producer.executer.LocalTransactionExecuter;
import com.alibaba.tmq.common.domain.Message;
import com.alibaba.tmq.common.domain.result.SendResult;
import com.alibaba.tmq.common.exception.TMQException;

/**
 * 事务生产者
 * @author tianyao.myc
 *
 */
public interface TransactionProducer extends Producer {

	/**
	 * 发送事物消息
	 *  message
	 *  localTransactionExecuter
	 *  object
	 *
	 *  TMQException
	 */
	public SendResult send(Message message, LocalTransactionExecuter localTransactionExecuter, Object object) throws TMQException;
	
	/**
	 * 批量发送事物消息
	 *  messageList
	 *  localTransactionExecuter
	 *  object
	 *
	 *  TMQException
	 */
	public SendResult send(List<Message> messageList, LocalTransactionExecuter localTransactionExecuter, Object object) throws TMQException;
	
}
