package com.alibaba.tmq.client.system.producer.executer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.alibaba.tmq.client.system.producer.NormalProducer;
import com.alibaba.tmq.client.system.producer.config.ProducerConfig;
import com.alibaba.tmq.client.system.producer.implement.DefaultNormalProducer;

/**
 * 普通生产者执行器
 * @author tianyao.myc
 *
 */
public class NormalProducerExecuter extends ProducerExecuter {

	private static final Log logger = LogFactory.getLog(NormalProducerExecuter.class);
	
	/** 生产者 */
	private final NormalProducer producer;
	
	public NormalProducerExecuter(ProducerConfig producerConfig) {
		
		super(producerConfig);
		
		this.producer = new DefaultNormalProducer(producerConfig, this);
	}

	public NormalProducer getProducer() {
		return producer;
	}
	
}
