package com.alibaba.tmq.client.system.producer.executer;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.alibaba.tmq.client.system.producer.config.ProducerConfig;
import com.alibaba.tmq.common.util.MapUtil;

/**
 * 生产者执行器
 * @author tianyao.myc
 *
 */
public class ProducerExecuter {

	private static final Log logger = LogFactory.getLog(ProducerExecuter.class);
	
	/** 心跳计数器映射表 */
	private final ConcurrentHashMap<String, AtomicLong> increaseCounterTable 	= new ConcurrentHashMap<String, AtomicLong>();
	private final ConcurrentHashMap<String, AtomicLong> compareCounterTable 	= new ConcurrentHashMap<String, AtomicLong>();
	
	/** 各项参数配置 */
	private final ProducerConfig producerConfig;
	
	//Producer是否启动
	private volatile boolean start = false;
	
	public ProducerExecuter(ProducerConfig producerConfig) {
		this.producerConfig = producerConfig;
	}

	public AtomicLong getIncreaseCounter(String server) {
		return MapUtil.getCounter(increaseCounterTable, server);
	}

	public AtomicLong getCompareCounter(String server) {
		return MapUtil.getCounter(compareCounterTable, server);
	}

	public ProducerConfig getProducerConfig() {
		return producerConfig;
	}

	public boolean isStart() {
		return start;
	}

	public void setStart(boolean start) {
		this.start = start;
	}
	
}
