package com.alibaba.tmq.client.util.Exception;


import java.io.PrintStream;
import java.io.PrintWriter;

/**
 * ��Ƕ�׵��쳣.
 *
 * @author Michael Zhou
 * @version $Id: ChainedRuntimeException.java 1291 2005-03-04 03:23:30Z baobao $
 */
public class ChainedRuntimeException extends RuntimeException
        implements ChainedThrowable {
    private static final long      serialVersionUID = 3257005466717533235L;
    private final ChainedThrowable delegate = new ChainedThrowableDelegate(this);
    private Throwable              cause;

    /**
     * ����һ���յ��쳣.
     */
    public ChainedRuntimeException() {
        super();
    }

    /**
     * ����һ���쳣, ָ���쳣����ϸ��Ϣ.
     *
     *  message ��ϸ��Ϣ
     */
    public ChainedRuntimeException(String message) {
        super(message);
    }

    /**
     * ����һ���쳣, ָ����������쳣������.
     *
     *  cause �쳣������
     */
    public ChainedRuntimeException(Throwable cause) {
        super((cause == null) ? null
                              : cause.getMessage());
        this.cause = cause;
    }

    /**
     * ����һ���쳣, ָ����������쳣������.
     *
     *  message ��ϸ��Ϣ
     *  cause �쳣������
     */
    public ChainedRuntimeException(String message, Throwable cause) {
        super(message);
        this.cause = cause;
    }

    /**
     * ȡ����������쳣������.
     *
     *  �쳣������.
     */
    public Throwable getCause() {
        return cause;
    }

    /**
     * ��ӡ����ջ����׼����.
     */
    public void printStackTrace() {
        delegate.printStackTrace();
    }

    /**
     * ��ӡ����ջ��ָ�������.
     *
     *  stream ����ֽ���.
     */
    public void printStackTrace(PrintStream stream) {
        delegate.printStackTrace(stream);
    }

    /**
     * ��ӡ����ջ��ָ�������.
     *
     *  writer ����ַ���.
     */
    public void printStackTrace(PrintWriter writer) {
        delegate.printStackTrace(writer);
    }

    /**
     * ��ӡ�쳣�ĵ���ջ, �����������쳣����Ϣ.
     *
     *  writer ��ӡ�������
     */
    public void printCurrentStackTrace(PrintWriter writer) {
        super.printStackTrace(writer);
    }
}
