package com.alibaba.tmq.common.domain;

/**
 * 消息执行结果
 * @author tianyao.myc
 *
 */
public enum Action {

	SUCCESS(MessageStatus.SUCCESS.getStatus()),
	
	//注意该项不再使用，如果有需要重试使用RETRY 不需要重试使用SUCCESS
	@Deprecated
	FAILURE(MessageStatus.FAILURE.getStatus()),
	
	RETRY(MessageStatus.RETRY.getStatus());
	
	private int status;
	
	private Action(int status) {
		this.status = status;
	}

	/**
	 * 重写toString方法
	 */
	public String toString() {
		return String.valueOf(status);
	}
	
	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}
	
}
