package com.alibaba.tmq.common.domain;

import java.util.Date;

import com.alibaba.tmq.common.constants.Constants;

/**
 * 集群
 * @author tianyao.myc
 *
 */
public class Cluster implements Constants {

	/** 唯一自增ID */
	private long id;
	
	/** 创建时间 */
	private Date gmtCreate;
	
	/** 修改时间 */
	private Date gmtModified;
	
	/** 描述 */
	private String description;
	
	/** 集群ID */
	private int clusterId;

	/**
	 * json转换成对象
	 *  json
	 *
	 */
	public static Cluster newInstance(String json) {
		
		String[] field = json.split(COLON);
		
		Cluster cluster = new Cluster();
		cluster.setId(Long.parseLong(field[0]));
		cluster.setGmtCreate(new Date(Long.parseLong(field[1])));
		cluster.setGmtModified(new Date(Long.parseLong(field[2])));
		cluster.setDescription(new String(getBytes(field[3]), DEFAULT_CHARSET));
		cluster.setClusterId(Integer.parseInt(field[4]));
		
        return cluster;
    }

    /**
     * 对象转换成json
     */
    @Override
    public String toString() {
    	
    	byte[] bytes = null;
    	try {
			bytes = this.description.getBytes(DEFAULT_CHARSET);
		} catch (Throwable e) {
			throw new RuntimeException("[Cluster]: toString error, description:" + this.description, e);
		}
    	
        return id + COLON + gmtCreate.getTime() + COLON + gmtModified.getTime() + COLON + getString(bytes) + COLON + clusterId;
    }
    
    /**
     * 编码成字符串
     *  bytes
     *
     */
    public static String getString(byte[] bytes) {
    	
    	StringBuilder sb = new StringBuilder();
    	
    	for(int i = 0 ; i < bytes.length ; i ++) {
    		sb.append(bytes[i] + COMMA_ENCODED);
    	}
    	
    	return sb.toString();
    }
    
    /**
     * 字符串还原成字节数组
     *  string
     *
     */
    public static byte[] getBytes(String string) {
    	
    	String[] charArray = string.split(COMMA_ENCODED);
    	
    	byte[] bytes = new byte[charArray.length];
    	for(int i = 0 ; i < charArray.length ; i ++) {
    		bytes[i] = Byte.parseByte(charArray[i]);
    	}
    	
    	return bytes;
    }
	
    /**
     * 检查集群ID是否有效
     *  clusterId
     *
     */
    public static boolean isValid(int clusterId) {
    	
    	if(ClusterEnum.DAILY.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	if(ClusterEnum.SECOND.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	if(ClusterEnum.TEST.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	if(ClusterEnum.DAILY_UNIT.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	if(ClusterEnum.PRE_CHINA.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	if(ClusterEnum.ONLINE_CHINA.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	if(ClusterEnum.B2B_PRE_CHINA.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	if(ClusterEnum.B2B_ONLINE_CHINA.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	if(ClusterEnum.PRE_USA.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	if(ClusterEnum.ONLINE_USA.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	if(ClusterEnum.PRE_USA_TWO.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	if(ClusterEnum.ONLINE_USA_TWO.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	if(ClusterEnum.PRE_DD.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	if(ClusterEnum.ONLINE_DD.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	return false;
    }
    
    /**
     * 是否是线上集群
     *  clusterId
     *
     */
    public static boolean isOnline(int clusterId) {
    	
    	if(ClusterEnum.ONLINE_CHINA.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	if(ClusterEnum.B2B_ONLINE_CHINA.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	if(ClusterEnum.ONLINE_USA.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	if(ClusterEnum.ONLINE_USA_TWO.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	if(ClusterEnum.PRE_DD.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	if(ClusterEnum.ONLINE_DD.getClusterId() == clusterId) {
    		return true;
    	}
    	
    	return false;
    }
    
	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public int getClusterId() {
		return clusterId;
	}

	public void setClusterId(int clusterId) {
		this.clusterId = clusterId;
	}

}
