package com.alibaba.tmq.common.domain;

import com.alibaba.tmq.common.constants.Constants;

/**
 * 集群枚举
 * @author tianyao.myc
 *
 */
public enum ClusterEnum implements Constants {

	DAILY(0, "日常"),
	
	SECOND(10, "二套"),
	
	TEST(11, "测试"),
	
	DAILY_UNIT(20, "日常单元"),
	
	PRE_CHINA(100, "中国预发"),//上海预发2（schema ：sh）
	
	ONLINE_CHINA(150, "中国线上"),//上海正式2（schema ：sh）
	
	B2B_PRE_CHINA(160, "B2B中国预发"),//B2B中国预发(schema ：b2b)
	
	B2B_ONLINE_CHINA(170, "B2B中国线上"),//B2B中国线上(schema ：b2b)
	
	PRE_USA(200, "AE美国预发"),//AE美国预发（schema ：us-ae）
	
	ONLINE_USA(250, "AE美国线上"),//AE美国线上（schema ：us-ae）
	
	PRE_USA_TWO(300, "美国预发"),//美国预发2（schema ：us）
	
	ONLINE_USA_TWO(350, "美国线上"),//美国线上2（schema ：us）
	
	PRE_DD(400, "钉钉预发"),
	
	ONLINE_DD(450, "钉钉线上");
	
	private int clusterId;
	
	private String description;
	
	private ClusterEnum(int clusterId, String description) {
		this.clusterId = clusterId;
		this.description = description;
	}
	
	/**
	 * 重写toString方法
	 */
	public String toString() {
		return clusterId + BLANK + description;
	}

	public int getClusterId() {
		return clusterId;
	}

	public void setClusterId(int clusterId) {
		this.clusterId = clusterId;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
}
