package com.alibaba.tmq.common.domain;

import java.io.Serializable;

/**
 * 消费者Key
 * @author tianyao.myc
 *
 */
public class ConsumerKey implements Serializable {

	private static final long serialVersionUID = -3201447968042584850L;

	/** 消费者ID */
	private String consumerId;
	
	/** 发布订阅主题 */
	private String topic;
	
	/** 消息类型 */
	private String tag;
	
	public ConsumerKey() {
		
	}
	
	public ConsumerKey(String consumerId, String topic, String tag) {
		this.consumerId = consumerId;
		this.topic = topic;
		this.tag = tag;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((consumerId == null) ? 0 : consumerId.hashCode());
		result = prime * result + ((tag == null) ? 0 : tag.hashCode());
		result = prime * result + ((topic == null) ? 0 : topic.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ConsumerKey other = (ConsumerKey) obj;
		if (consumerId == null) {
			if (other.consumerId != null)
				return false;
		} else if (!consumerId.equals(other.consumerId))
			return false;
		if (tag == null) {
			if (other.tag != null)
				return false;
		} else if (!tag.equals(other.tag))
			return false;
		if (topic == null) {
			if (other.topic != null)
				return false;
		} else if (!topic.equals(other.topic))
			return false;
		return true;
	}

	public String getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(String consumerId) {
		this.consumerId = consumerId;
	}

	public String getTopic() {
		return topic;
	}

	public void setTopic(String topic) {
		this.topic = topic;
	}

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	@Override
	public String toString() {
		return "ConsumerKey [consumerId=" + consumerId + ", topic=" + topic
				+ ", tag=" + tag + "]";
	}

}
