package com.alibaba.tmq.common.domain;

import com.alibaba.tmq.common.remoting.protocol.RemotingSerializable;

/**
 * 环境信息
 * @author tianyao.myc
 *
 */
public class Environment {

	public static final String ENVIRONMENT_DATA_ID = "tmq_environment_data_id_2015_07_06";
	
	/** 分库数据源appName */
	private String dataSourceAppName;
	
	/** Meta库数据源appName */
	private String dataSourceAppNameMeta;
	
	/** Meta库GroupKey */
	private String dbGroupKeyMeta;
	
	/** TDDL规则配置文件 */
	private String tddlAppruleFile;
	
	private String group;
	
	/** 服务器集群ID */
	private int clusterId;
	
	// ZK的服务器地址列表，逗号分隔
    protected String zkHosts;
    
    public Environment(String dataSourceAppName, 
    		String dataSourceAppNameMeta, 
    		String dbGroupKeyMeta, 
    		String tddlAppruleFile, 
    		String group, int clusterId, String zkHosts) {
    	this.dataSourceAppName 		= dataSourceAppName;
    	this.dataSourceAppNameMeta 	= dataSourceAppNameMeta;
    	this.dbGroupKeyMeta 		= dbGroupKeyMeta;
    	this.tddlAppruleFile 		= tddlAppruleFile;
    	this.group 					= group;
    	this.clusterId 				= clusterId;
    	this.zkHosts 				= zkHosts;
    }
    
    public Environment() {
    	
    }
	
	/**
     * 对象转换成json
     */
    public String toString() {
        return RemotingSerializable.toJson(this, false);
    }
	
    /**
     * String转换成对象
     *  json
     *
     */
    public static Environment newInstance(String json) {
        return RemotingSerializable.fromJson(json, Environment.class);
    }

	public String getDataSourceAppName() {
		return dataSourceAppName;
	}

	public void setDataSourceAppName(String dataSourceAppName) {
		this.dataSourceAppName = dataSourceAppName;
	}

	public String getDataSourceAppNameMeta() {
		return dataSourceAppNameMeta;
	}

	public void setDataSourceAppNameMeta(String dataSourceAppNameMeta) {
		this.dataSourceAppNameMeta = dataSourceAppNameMeta;
	}

	public String getDbGroupKeyMeta() {
		return dbGroupKeyMeta;
	}

	public void setDbGroupKeyMeta(String dbGroupKeyMeta) {
		this.dbGroupKeyMeta = dbGroupKeyMeta;
	}

	public String getTddlAppruleFile() {
		return tddlAppruleFile;
	}

	public void setTddlAppruleFile(String tddlAppruleFile) {
		this.tddlAppruleFile = tddlAppruleFile;
	}

	public String getGroup() {
		return group;
	}

	public void setGroup(String group) {
		this.group = group;
	}

	public int getClusterId() {
		return clusterId;
	}

	public void setClusterId(int clusterId) {
		this.clusterId = clusterId;
	}

	public String getZkHosts() {
		return zkHosts;
	}

	public void setZkHosts(String zkHosts) {
		this.zkHosts = zkHosts;
	}

}
