package com.alibaba.tmq.common.domain;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;

import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.remoting.protocol.RemotingSerializable;

/**
 * 环境集合
 * @author tianyao.myc
 *
 */
public class EnvironmentSet implements Constants, Serializable {

	private static final long serialVersionUID = -2673401539091039105L;

	public static final String TMQ_ENVIRONMENT_SET_DIAMOND_DATA_ID = "com.alibaba.tmq.EnvironmentSet";
	
	/** hosts关系映射表 */
	private ConcurrentHashMap<Integer, Environment> environmentTable = new ConcurrentHashMap<Integer, Environment>();
	
	public EnvironmentSet() {
		
	}

	public ConcurrentHashMap<Integer, Environment> getEnvironmentTable() {
		return environmentTable;
	}

	public void setEnvironmentTable(ConcurrentHashMap<Integer, Environment> environmentTable) {
		this.environmentTable = environmentTable;
	}
	
	/**
	 * 放入环境信息
	 *  environment
	 */
	public void put(Environment environment) {
		
		//放入环境信息
		put(environment.getClusterId(), environment);
	}
	
	/**
	 * 放入环境信息
	 *  clusterId
	 *  environment
	 */
	public void put(int clusterId, Environment environment) {
		this.environmentTable.put(clusterId, environment);
	}
	
	/**
	 * 获取环境
	 *  clusterId
	 *
	 */
	public Environment get(int clusterId) {
		return this.environmentTable.get(clusterId);
	}

	/**
	 * json转换成对象
	 *  json
	 *
	 */
	public static EnvironmentSet newInstance(String json) {
        return RemotingSerializable.fromJson(json, EnvironmentSet.class);
    }
	
	/**
     * 对象转换成json
     */
    @Override
    public String toString() {
        return RemotingSerializable.toJson(this, false);
    }
	
}
