package com.alibaba.tmq.common.domain;

import java.io.Serializable;

import com.alibaba.tmq.common.constants.Constants;

/**
 * 单元Key
 * @author tianyao.myc
 *
 */
public class UnitKey implements Constants, Serializable {

	private static final long serialVersionUID = -927358953618316844L;

	//单元
	private String unit;
	
	/** 发布订阅主题 */
	private String topic;
	
	/** 消息类型 */
	private String tag;
	
	public UnitKey() {
		
	}
	
	public UnitKey(String unit, String topic, String tag) {
		this.unit = unit;
		this.topic = topic;
		this.tag = tag;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((tag == null) ? 0 : tag.hashCode());
		result = prime * result + ((topic == null) ? 0 : topic.hashCode());
		result = prime * result + ((unit == null) ? 0 : unit.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		UnitKey other = (UnitKey) obj;
		if (tag == null) {
			if (other.tag != null)
				return false;
		} else if (!tag.equals(other.tag))
			return false;
		if (topic == null) {
			if (other.topic != null)
				return false;
		} else if (!topic.equals(other.topic))
			return false;
		if (unit == null) {
			if (other.unit != null)
				return false;
		} else if (!unit.equals(other.unit))
			return false;
		return true;
	}

	public String getUnit() {
		return unit;
	}

	public void setUnit(String unit) {
		this.unit = unit;
	}

	public String getTopic() {
		return topic;
	}

	public void setTopic(String topic) {
		this.topic = topic;
	}

	public String getTag() {
		return tag;
	}

	public void setTag(String tag) {
		this.tag = tag;
	}

	@Override
	public String toString() {
		return "UnitKey [unit=" + unit + ", topic=" + topic + ", tag=" + tag
				+ "]";
	}
	
}
