package com.alibaba.tmq.common.domain.remoting.protocol;

import java.io.Serializable;
import java.util.Arrays;

import com.alibaba.tmq.common.domain.remoting.ConnectionChannel;

/**
 * 调用方法
 * @author tianyao.myc
 *
 */
public class InvokeMethod implements Serializable {

	private static final long serialVersionUID = -2034177077731417055L;

	/** 连接信道 */
	private ConnectionChannel connectionChannel;
	
	/** 调用方法 */
	private String methodName;
	
	/** 参数类型 */
	private Class<?>[] parameterTypes;
	
	/** 参数 */
	private Object[] arguments;
	
	public InvokeMethod() {
		
	}
	
	public InvokeMethod(ConnectionChannel connectionChannel, String methodName, Class<?>[] parameterTypes, Object[] arguments) {
		this.connectionChannel = connectionChannel;
		this.methodName = methodName;
		this.parameterTypes = parameterTypes;
		this.arguments = arguments;
	}
	
	/**
	 * 信息反转 
	 */
	public void reversal() {
		
		//信息反转
		this.connectionChannel.reversal();
	}

	public ConnectionChannel getConnectionChannel() {
		return connectionChannel;
	}

	public void setConnectionChannel(ConnectionChannel connectionChannel) {
		this.connectionChannel = connectionChannel;
	}

	public String getMethodName() {
		return methodName;
	}

	public void setMethodName(String methodName) {
		this.methodName = methodName;
	}

	public Class<?>[] getParameterTypes() {
		return parameterTypes;
	}

	public void setParameterTypes(Class<?>[] parameterTypes) {
		this.parameterTypes = parameterTypes;
	}

	public Object[] getArguments() {
		return arguments;
	}

	public void setArguments(Object[] arguments) {
		this.arguments = arguments;
	}

	@Override
	public String toString() {
		return "InvokeMethod [connectionChannel=" + connectionChannel
				+ ", methodName=" + methodName + ", parameterTypes="
				+ Arrays.toString(parameterTypes) + ", arguments="
				+ Arrays.toString(arguments) + "]";
	}

}
