package com.alibaba.tmq.common.domain.result;

import java.io.Serializable;

import com.alibaba.tmq.common.constants.Constants;

/**
 * 返回值
 * @author tianyao.myc
 *
 */
public class Result<D> implements Constants, Serializable {

	private static final long serialVersionUID = -7291619416855345450L;

	/** 返回数据 */
	private D data;
	
	/** 返回码 */
	private ResultCode resultCode;
	
	public Result() {
		
	}
	
	public Result(D data) {
		this.data = data;
	}
	
	public Result(ResultCode resultCode) {
		this.resultCode = resultCode;
	}
	
	public Result(D data, ResultCode resultCode) {
		this.data = data;
		this.resultCode = resultCode;
	}

	/**
	 * 重写toString方法
	 */
	public String toString() {
		return data + BLANK + resultCode;
	}
	
	public D getData() {
		return data;
	}

	public void setData(D data) {
		this.data = data;
	}

	public ResultCode getResultCode() {
		return resultCode;
	}

	public void setResultCode(ResultCode resultCode) {
		this.resultCode = resultCode;
	}
	
}
