package com.alibaba.tmq.common.domain.result;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.tmq.common.domain.KeyValuePair;
import com.alibaba.tmq.common.domain.Message;

/**
 * 提交结果
 * @author tianyao.myc
 *
 */
public class SubmitResult extends Result<Boolean> {

	private static final long serialVersionUID = 1471410852176915719L;
	
	/** 消息列表 */
	private List<KeyValuePair<String/**系统生成32位消息全局唯一ID*/, Message>> messageKeyValueList = new ArrayList<KeyValuePair<String, Message>>();
	
	/** 消息全局唯一ID */
	private String messageId;
	
	public SubmitResult() {
		
	}
	
	public SubmitResult(Boolean data) {
		super(data);
	}
	
	public SubmitResult(ResultCode resultCode) {
		super(resultCode);
	}
	
	public SubmitResult(Result<Boolean> result) {
		super(result.getData(), result.getResultCode());
	}
	
	public SubmitResult(Result<Boolean> result, KeyValuePair<String, Message> messageKeyValue) {
		super(result.getData(), result.getResultCode());
		this.messageKeyValueList.add(messageKeyValue);
	}
	
	public SubmitResult(Result<Boolean> result, List<KeyValuePair<String, Message>> messageKeyValueList) {
		super(result.getData(), result.getResultCode());
		this.messageKeyValueList.addAll(messageKeyValueList);
	}
	
	public SubmitResult(Boolean data, ResultCode resultCode) {
		super(data, resultCode);
	}

	public SubmitResult(Boolean data, ResultCode resultCode, KeyValuePair<String, Message> messageKeyValue) {
		super(data, resultCode);
		this.messageKeyValueList.add(messageKeyValue);
	}

	public SubmitResult(Boolean data, ResultCode resultCode, List<KeyValuePair<String, Message>> messageKeyValueList) {
		super(data, resultCode);
		this.messageKeyValueList.addAll(messageKeyValueList);
	}
	
	public List<KeyValuePair<String, Message>> getMessageKeyValueList() {
		return messageKeyValueList;
	}

	public void setMessageKeyValueList(
			List<KeyValuePair<String, Message>> messageKeyValueList) {
		this.messageKeyValueList = messageKeyValueList;
	}

	public String getMessageId() {
		
		if(null == this.messageKeyValueList || this.messageKeyValueList.size() <= 0) {
			return messageId;
		}
		
		messageId = this.messageKeyValueList.get(0).getKey();
		
		return messageId;
	}

	public void setMessageId(String messageId) {
		this.messageId = messageId;
	}

	@Override
	public String toString() {
		return "SubmitResult [messageKeyValueList=" + messageKeyValueList
				+ ", messageId=" + messageId + ", getData()=" + getData()
				+ ", getResultCode()=" + getResultCode() + "]";
	}

}
