package com.alibaba.tmq.common.monitor.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.monitor.MethodMonitor;

/**
 * 方法调用拦截
 * @author tianyao.myc
 *
 */
public class MethodInvocationHandler implements InvocationHandler, Constants {

	private Object business;//被代理对象

	private final MethodMonitor methodMonitor;

	public MethodInvocationHandler(MethodMonitor methodMonitor) {
		this.methodMonitor = methodMonitor;
	}

	/**
	 * 绑定对象
	 *  business
	 *
	 */
	public Object bind(Object business) {
		this.business = business;
		return Proxy.newProxyInstance(
                //被代理类的ClassLoader
                business.getClass().getClassLoader(),
                //要被代理的接口,本方法返回对象会自动声称实现了这些接口
                business.getClass().getInterfaces(),
                //代理处理器对象
                this);
	}

	/**
	 * 代理方法
	 */
	public Object invoke(Object proxy, Method method, Object[] args)
			throws Throwable {

		long startTime = System.currentTimeMillis();

		Object result = null;

		result = method.invoke(this.business, args);

		//方法调用统计
		this.methodMonitor.methodCount(this.business.getClass().getSimpleName() + POINT + method.getName(), startTime);
		return result;
	}

}
