package com.alibaba.tmq.common.service;

import java.util.List;

import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.PostMethod;

import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.domain.KeyValuePair;
import com.alibaba.tmq.common.domain.ServerList;

/**
 * HTTP 服务
 * @author tianyao.myc
 *
 */
public class HttpService implements Constants {
	
	public static final String DOMAIN_NAME_DATA_ID = "com.alibaba.tmq.common.domainName";

	private static final Logger logger = SchedulerXLoggerFactory.getLogger(HttpService.class);
	
	/** 请求参数设置 */
	private static final int timeout 						= 10000;
	private static final int httpConnectionFactoryTimeout 	= 10000;
	private static final int connectionTimeout 				= 10000;
	
	/** 默认编码为 */
	public static final String DEFAULT_CHARSET = "UTF-8";
	
	/**
	 * 获取服务端地址列表
	 *  domainName
	 *  clusterId
	 *
	 */
	public List<String> acquireServers(String domainName, long clusterId) {
		
		String url = "http://" + domainName + "/tmq-console/apiManager.do?action=ApiAction&event_submit_do_acquire_servers=1&clusterId=" + clusterId;
		
		String result = null;
		try {
			result = go(url);
		} catch (Throwable e) {
			logger.warn("[HttpService]: acquireServers error, url:" + url , e);
		}
		
		ServerList serverList = null;
		try {
			serverList = ServerList.newInstance(result);
		} catch (Throwable e) {
			logger.warn("[HttpService]: ServerList.newInstance error"
					+ ", url:" + url 
					+ ", result:" + result , e);
		}
		
		if(null == serverList) {
			logger.warn("[HttpService]: ServerList.newInstance failed"
					+ ", url:" + url 
					+ ", result:" + result);
			return null;
		}
		
		return serverList.getServers();
	}
	
	/**
	 * 获取zk地址列表
	 *  url
	 *
	 */
	private String go(String url) {
		
		KeyValuePair<Integer, PostMethod> pair = request(url);
		
		try {
			return pair.getValue().getResponseBodyAsString();
		} catch (Throwable e) {
			
			logger.warn("[HttpService]: go getResponseBodyAsString error, url:" + url, e);
			
			return null;
		}
	}
	
	/**
	 * 发起请求
	 *  url
	 *
	 */
	@SuppressWarnings("deprecation")
	public KeyValuePair<Integer, PostMethod> request(String url) {
		
		HttpClient client = new HttpClient();
		
		/** 参数设置 */
		client.setTimeout(timeout);
		client.setConnectionTimeout(connectionTimeout);
		client.setHttpConnectionFactoryTimeout(httpConnectionFactoryTimeout);
		
		/** POST请求 */
		PostMethod post = new PostMethod(url);
		
		post.addRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=" + DEFAULT_CHARSET);
		
		int resultCode = 0;
		try {
			resultCode = client.executeMethod(post);
		} catch (Throwable e) {
			logger.warn("[HttpService]: executeMethod error, post:" + post, e);
		}
		
		return new KeyValuePair<Integer, PostMethod>(resultCode, post);
	}
	
}
