package com.alibaba.tmq.common.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

/**
 * Map相关工具
 * @author tianyao.myc
 *
 */
public class MapUtil {

	/**
	 * 多线程环境同一个key拿到同一个counter
	 *  counterMap
	 *  key
	 *
	 */
	public static AtomicLong getCounter(ConcurrentHashMap<String, AtomicLong> counterMap, String key) {
		AtomicLong counter = counterMap.get(key);
		if(null == counter) {
			counter = new AtomicLong(0L);
			AtomicLong existCounter = counterMap.putIfAbsent(key, counter);
			if(existCounter != null) {
				counter = existCounter;
			}
		}
		return counter;
	}
	
}
