package com.alibaba.tmq.common.util;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.tmq.common.constants.Constants;
import com.alibaba.tmq.common.domain.KeyValuePair;

/**
 * 表相关工具
 * @author tianyao.myc
 *
 */
public class TableUtil implements Constants {

	/**
	 * 初始化Table列表
	 *  group
	 *
	 */
	public static List<KeyValuePair<String, String>> initTableList(String group) {
		
		/** table列表缓存 */
		List<KeyValuePair<String, String>> tablePairList = new ArrayList<KeyValuePair<String, String>>();
		
		for(int i = 0 ; i < TABLE_AMOUNT ; i ++) {
			
			//添加Table信息
			tablePairList.add(new KeyValuePair<String, String>(createDbGroup(group, i), createTable(i)));
		}
		
		return tablePairList;
	}
	
	/**
	 * 初始化Table列表
	 *  group
	 *  serverAmount
	 *  serverNumber
	 *
	 */
	public static List<KeyValuePair<String, String>> initTableList(String group, int serverAmount, int serverNumber) {
		
		/** table列表缓存 */
		List<KeyValuePair<String, String>> tablePairList = new ArrayList<KeyValuePair<String, String>>();
		
		for(int i = 0 ; i < TABLE_AMOUNT ; i ++) {
			
			if(serverNumber == i % serverAmount) {
				
				String dbGroup = createDbGroup(group, i);
				String table = createTable(i);
				
				tablePairList.add(new KeyValuePair<String, String>(dbGroup, table));
			}
			
		}
		
		return tablePairList;
	}
	
	/**
	 * 获取该消息要触发的那台Server
	 *  serverList
	 *  messageKey
	 *
	 */
	public static String acquireFireServer(List<String> serverList, String messageKey) {
		if(ListUtil.isEmpty(serverList)) {
			return null;
		}
		int table = Math.abs(messageKey.hashCode()) % TABLE_AMOUNT;
		int index = table % serverList.size();
		return serverList.get(index);
	}
	
	/**
	 * 创建db分组
	 *  dbGroup
	 *  index
	 *
	 */
	public static String createDbGroup(String group, int index) {
		return group + decimalFormat.format(index / 64) + "_GROUP";
	}
	
	/**
	 * 创建表
	 *  index
	 *
	 */
	public static String createTable(int index) {
		return TMQ_MESSAGE_TABLE_NAME + UNDERLINE + decimalFormat.format(index);
	}
	
}
