package com.alibaba.tmq.common.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.alibaba.tmq.common.constants.Constants;

/**
 * 时间相关工具
 * @author tianyao.myc
 *
 */
public class TimeUtil implements Constants {

	private static final Log logger = LogFactory.getLog(TimeUtil.class);
	
    public static String date2SecondsString(Date date) {
        return format(date, TIME_FORMAT_SECONDS);
    }
    
    public static String date2MilliSeconds(Date date) {
        return format(date, TIME_FORMAT_MILLISECONDS);
    }
    
    /**
	 * 把时间转换成相应格式的字符串
	 *  date
	 *  format
	 *
	 */
	public static String format(Date date, String format) {
		SimpleDateFormat formater = 
				new SimpleDateFormat(format);
		return formater.format(date);
	}
	
	/**
	 * 格式化时间
	 *  date
	 *  sourceFormat
	 *  targetFormat
	 *
	 */
	public static String format(String date, String sourceFormat, String targetFormat) {
		return format(string2Date(date, sourceFormat), targetFormat);
	}
	
	/**
	 * String转Date
	 *  date
	 *
	 */
	public static Date string2Date(String date) {
		
		SimpleDateFormat formater = new SimpleDateFormat(TIME_FORMAT_SECONDS);
		
		try {
			return formater.parse(date);
		} catch (Throwable e) {
			logger.error("[TimeUtil]: string2Date error, date:" + date, e);
		}
		
		return null;
	}
	
	/**
	 * String转Date
	 *  date
	 *  format
	 *
	 */
	public static Date string2Date(String date, String format) {
		
		SimpleDateFormat formater = new SimpleDateFormat(format);
		
		try {
			return formater.parse(date);
		} catch (Throwable e) {
			logger.error("[TimeUtil]: string2Date error, date:" + date + ", format:" + format, e);
		}
		
		return null;
	}
	
	/**
	 * 精确到秒
	 *  date
	 *
	 */
	public static Date date2Seconds(Date date) {
		
		return string2Date(format(date, TIME_FORMAT_SECONDS));
	}
	
	/**
	 * 精确到分钟
	 *  date
	 *
	 */
	public static Date date2Minute(Date date) {
		
		return string2Date(format(date, TIME_FORMAT_CHART), TIME_FORMAT_CHART);
	}
	
	/**
	 * 增加时间
	 *  date
	 *  field
	 *  amount
	 *
	 */
	public static Date increaseDate(Date date, int field, int amount) {
		Calendar calendar = Calendar.getInstance();
		calendar.setTime(date);
		calendar.add(field, amount);
		return calendar.getTime();
	}
	
	/**
	 * 获取时间间隔
	 *  initDelay
	 *  increaseRate
	 *  retryCount
	 *
	 */
	public static int getTimeInterval(int initDelay, double increaseRate, int retryCount) {
		return (int)(initDelay + retryCount * increaseRate * initDelay);
	}
}
