/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client;

import com.alibaba.dts.client.ClientService;
import com.alibaba.dts.client.executor.grid.flowcontrol.FlowControlStrategy;
import com.alibaba.dts.client.executor.job.context.ClientContext;
import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.processor.FailureJobProcessor;
import com.alibaba.dts.client.executor.job.processor.StopJobProcessor;
import com.alibaba.dts.client.route.RouteRule;
import com.alibaba.dts.client.store.StoreStrategy;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.LoggerCleaner;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.util.GroupIdUtil;
import com.alibaba.dts.common.util.PathUtil;
import com.alibaba.dts.common.util.StringUtil;
import com.alibaba.dts.shade.com.taobao.common.fulllinkstresstesting.SplitEnvUtil;
import com.alibaba.edas.schedulerx.SchedulerXLogLevel;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class SchedulerxClient
implements ApplicationContextAware,
ApplicationListener,
Constants,
ClientService {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(SchedulerxClient.class);
    private final ClientContextImpl clientContext = new ClientContextImpl();
    private static final ConcurrentHashMap<String, Boolean> clientTable = new ConcurrentHashMap();
    private static Object lock = new Object();
    private SchedulerXLogLevel defaultLogLevel = SchedulerXLogLevel.WARN;
    private SchedulerXLogLevel executeLogLevel = SchedulerXLogLevel.WARN;
    private LoggerCleaner loggerCleaner = new LoggerCleaner(PathUtil.getLoggerPath());

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.clientContext.getJobProcessorFactory().setApplicationContext(applicationContext);
        this.clientContext.getClientConfig().setSpring(true);
        logger.warn("[SchedulerxClient]: setApplicationContext over, applicationContext:" + applicationContext);
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (!(applicationEvent instanceof ContextRefreshedEvent)) {
            return;
        }
        if (!this.clientContext.getClientConfig().isAutoInit()) {
            logger.info("[SchedulerxClient]: do not AutoInit, clientConfig:" + this.clientContext.getClientConfig());
            return;
        }
        try {
            this.init();
        }
        catch (Throwable e) {
            String info = "[SchedulerxClient]: init error, clientConfig:" + this.clientContext.getClientConfig();
            logger.error(info, e);
            throw new RuntimeException(info, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws InitException {
        SchedulerXLoggerFactory.initLogByLevel(this.defaultLogLevel.getInformation(), this.executeLogLevel.getInformation());
        if (!("SchedulerX".equals(this.clientContext.getClientConfig().getEnvironment()) || "PrivateCloud".equals(this.clientContext.getClientConfig().getEnvironment()) || SplitEnvUtil.needStartDtsOnlyByEnv())) {
            logger.info("SchedulerxClient, yace env!");
        }
        this.clientContext.getClientConfig().init();
        this.clientContext.getNodeServerServiceLocal().init();
        if ("SchedulerX".equals(this.clientContext.getClientConfig().getEnvironment())) {
            if (this.clientContext.getClientConfig().getInnerDebug() == 1) {
                this.clientContext.getHttpService().setUseHttps(false);
            } else {
                this.clientContext.getHttpService().setUseHttps(true);
            }
            if (StringUtil.isEmpty(this.clientContext.getClientConfig().getGroupId())) {
                this.initGroupId(this.clientContext.getClientConfig().getServiceGroup(), this.clientContext.getClientConfig().getRegionName(), this.clientContext.getClientConfig().getServiceGroupId());
            }
        }
        GroupIdUtil.checkGroupId(this.clientContext.getClientConfig().getGroupId());
        Object object = lock;
        synchronized (object) {
            logger.warn("[SchedulerxClient]: tell initialized, thread:" + Thread.currentThread().getName() + ", groupId:" + this.clientContext.getClientConfig().getGroupId());
            Boolean init = clientTable.get(this.clientContext.getClientConfig().getGroupId());
            if (null != init) {
                logger.warn("SchedulerxClient has already initialized, thread:" + Thread.currentThread().getName() + ", groupId:" + this.clientContext.getClientConfig().getGroupId());
                return;
            }
            clientTable.put(this.clientContext.getClientConfig().getGroupId(), new Boolean(true));
        }
        this.clientContext.getStore().init();
        this.clientContext.getCompensationTimer().init();
        this.clientContext.getLogCleaner().init();
        this.clientContext.getZookeeper().init();
        if ("SchedulerX".equals(this.clientContext.getClientConfig().getEnvironment())) {
            this.clientContext.getSecurityCheck().init();
        }
        this.clientContext.getFlowControlChain().init();
        this.clientContext.getHealthChecker().init();
        this.clientContext.getClientRemoting().init();
        this.clientContext.getNodeRemoting().init();
        if (!this.clientContext.getClientConfig().isAgent()) {
            this.clientContext.getJobProcessorFactory().init();
        }
        if (this.clientContext.getClientConfig().isAgent()) {
            this.loggerCleaner.init();
        }
        this.clientContext.getGridTaskSender().init();
        logger.warn("[SchedulerxClient]: init over");
        logger.warn("[SchedulerxClient]: ClientConfig:" + this.clientContext.getClientConfig().toString());
        logger.warn("[SchedulerxClient]: NodeConfig:" + this.clientContext.getNodeConfig());
    }

    @Override
    public void initGroupId(String serviceGroup, String regionName, String serviceGroupId) throws InitException {
        if (StringUtil.isBlank(serviceGroupId)) {
            throw new InitException("[InitGroupId]: serviceGroupId  is null!");
        }
        if (StringUtil.isBlank(serviceGroup) || StringUtil.isBlank(regionName)) {
            throw new InitException("[InitGroupId]: serviceGroup or regionName is null!");
        }
        if (StringUtil.isBlank(serviceGroup) || StringUtil.isBlank(regionName)) {
            throw new InitException("[InitGroupId]: serviceGroup or regionName is null!");
        }
        Result<String> result = this.clientContext.getHttpService().acquireGroupID(this.clientContext.getClientConfig().getDomainName(), serviceGroupId, regionName);
        if (result.getResultCode() == null) {
            throw new InitException("[InitGroupId]: get groupid error, return null!");
        }
        if (result.getResultCode() != ResultCode.SUCCESS) {
            throw new InitException("[InitGroupId]: get groupid error," + result.getResultCode().getInformation());
        }
        if (StringUtil.isEmpty(result.getData())) {
            throw new InitException("[InitGroupId]: get groupid error," + result.getResultCode().getInformation());
        }
        this.clientContext.getClientConfig().setGroupId(result.getData());
    }

    @Override
    public ClientContext getClientContext() {
        return this.clientContext;
    }

    @Override
    public void setNewInstance(boolean newInstance) {
        this.clientContext.getClientConfig().setNewInstance(newInstance);
    }

    public void setSpring(boolean isSpring, ApplicationContext applicationContext) {
        this.clientContext.getClientConfig().setSpring(isSpring);
        if (isSpring) {
            this.clientContext.getJobProcessorFactory().setApplicationContext(applicationContext);
        }
    }

    @Override
    public void setRemotingThreads(int remotingThreads) {
        this.clientContext.getClientConfig().setRemotingThreads(remotingThreads);
        this.clientContext.getNodeConfig().setRemotingThreads(remotingThreads);
    }

    @Override
    public void setHeartBeatIntervalTime(long heartBeatIntervalTime) {
        this.clientContext.getClientConfig().setHeartBeatIntervalTime(heartBeatIntervalTime);
    }

    @Override
    public void setConnectionTimeout(long connectionTimeout) {
        this.clientContext.getClientConfig().setConnectionTimeout(connectionTimeout);
    }

    @Override
    public void setGroupId(String groupId) {
        this.clientContext.getClientConfig().setGroupId(groupId);
        this.clientContext.getNodeConfig().setGroupId(groupId);
    }

    @Override
    public void setZkHosts(String zkHosts) {
        this.clientContext.getClientConfig().setZkHosts(zkHosts);
    }

    @Override
    public void setNamespace(String namespace) {
        this.clientContext.getClientConfig().setNamespace(namespace);
    }

    @Override
    public void setZkSessionTimeout(int zkSessionTimeout) {
        this.clientContext.getClientConfig().setZkSessionTimeout(zkSessionTimeout);
    }

    @Override
    public void setZkConnectionTimeout(int zkConnectionTimeout) {
        this.clientContext.getClientConfig().setZkConnectionTimeout(zkConnectionTimeout);
    }

    @Override
    public void setQueueSize(int queueSize) {
        this.clientContext.getClientConfig().setQueueSize(queueSize);
    }

    @Override
    public void setConsumerThreads(int consumerThreads) {
        this.clientContext.getClientConfig().setConsumerThreads(consumerThreads);
    }

    @Override
    public void setConsumerThreadsMap(Map<String, Integer> consumerThreadsMap) {
        this.clientContext.getClientConfig().setConsumerThreadsMap(consumerThreadsMap);
    }

    @Override
    public void setPageSize(int pageSize) {
        if (pageSize <= 0) {
            pageSize = 1000;
        }
        this.clientContext.getClientConfig().setPageSize(pageSize);
        this.clientContext.getNodeConfig().setTaskInsertBatchSize(pageSize);
    }

    @Override
    public void setPageSizeMap(Map<String, Integer> pageSizeMap) {
        this.clientContext.getClientConfig().setPageSizeMap(pageSizeMap);
    }

    @Override
    public void setAccessKey(String accessKey) {
        this.clientContext.getClientConfig().setAccessKey(accessKey);
    }

    @Override
    public void setSecretKey(String secretKey) {
        this.clientContext.getClientConfig().setSecretKey(secretKey);
    }

    @Override
    public void setCrashRetry(boolean crashRetry) {
        this.clientContext.getClientConfig().setCrashRetry(crashRetry);
    }

    @Override
    public void setZkHostsAutoChange(boolean zkHostsAutoChange) {
        this.clientContext.getClientConfig().setZkHostsAutoChange(zkHostsAutoChange);
    }

    @Override
    public void setPullTaskListOverSleepTime(long pullTaskListOverSleepTime) {
        this.clientContext.getClientConfig().setPullTaskListOverSleepTime(pullTaskListOverSleepTime);
    }

    @Override
    public void setFailureJobProcessorMap(Map<String, FailureJobProcessor> failureJobProcessorMap) {
        this.clientContext.getClientConfig().setFailureJobProcessorMap(failureJobProcessorMap);
    }

    @Override
    public void setFinishLog(boolean finishLog) {
        this.clientContext.getClientConfig().setFinishLog(finishLog);
    }

    @Override
    public void setStopJobProcessor(StopJobProcessor stopJobProcessor) {
        this.clientContext.getClientConfig().setStopJobProcessor(stopJobProcessor);
    }

    @Override
    public void setEveryTimeNew(boolean isEveryTimeNew) {
        this.clientContext.getClientConfig().setEveryTimeNew(isEveryTimeNew);
    }

    @Override
    public void setEnvironment(String environment) {
        this.clientContext.getClientConfig().setEnvironment(environment);
        this.clientContext.getNodeConfig().setEnvironment(environment);
    }

    @Override
    public void setServiceGroup(String serviceGroup) {
        this.clientContext.getClientConfig().setServiceGroup(serviceGroup);
    }

    @Override
    public void setServiceGroupId(String serviceGroupId) {
        this.clientContext.getClientConfig().setServiceGroupId(serviceGroupId);
    }

    @Override
    public void setRegionName(String regionName) {
        this.clientContext.getClientConfig().setRegionName(regionName);
    }

    @Override
    public void setInnerDebug(int innerDebug) {
        this.clientContext.getClientConfig().setInnerDebug(innerDebug);
    }

    public void setNewVersion(boolean newVersion) {
        this.clientContext.getClientConfig().setNewVersion(newVersion);
    }

    @Override
    public void setDomainName(String domainName) {
        if (StringUtil.isBlank(domainName) || "default".equals(domainName)) {
            return;
        }
        this.clientContext.getClientConfig().setDomainName(domainName);
    }

    @Override
    public void setAutoInit(boolean autoInit) {
        this.clientContext.getClientConfig().setAutoInit(autoInit);
    }

    @Override
    public ClassLoader getCustomerClassLoader() {
        return this.clientContext.getProxyService().getCustomerClassLoader();
    }

    @Override
    public void setCustomerClassLoader(ClassLoader customerClassLoader) {
        this.clientContext.getProxyService().setCustomerClassLoader(customerClassLoader);
    }

    @Override
    public SchedulerXLogLevel getDefaultLogLevel() {
        return this.defaultLogLevel;
    }

    @Override
    public void setDefaultLogLevel(SchedulerXLogLevel defaultLogLevel) {
        this.defaultLogLevel = defaultLogLevel;
    }

    @Override
    public SchedulerXLogLevel getExecuteLogLevel() {
        return this.executeLogLevel;
    }

    @Override
    public void setExecuteLogLevel(SchedulerXLogLevel executeLogLevel) {
        this.executeLogLevel = executeLogLevel;
    }

    public void setMaxBodySize(long maxBodySize) {
        this.clientContext.getClientConfig().setMaxBodySize(maxBodySize);
    }

    public void setListenPort(int listenerPort) {
        this.clientContext.getNodeConfig().setListenPort(listenerPort);
    }

    public void setSystemListenPort(int systemListenPort) {
        this.clientContext.getNodeConfig().setSystemListenPort(systemListenPort);
    }

    public void setLocalAddress(String localAddress) {
        this.clientContext.getNodeConfig().setLocalAddress(localAddress);
    }

    public void setConnectTimeout(long connectTimeout) {
        this.clientContext.getNodeConfig().setConnectTimeout(connectTimeout);
    }

    public void setHeartbeatInterval(long heartbeatInterval) {
        this.clientContext.getNodeConfig().setHeartbeatInterval(heartbeatInterval);
    }

    public void setDbPath(String dbPath) {
        this.clientContext.getNodeConfig().setDbPath(dbPath);
    }

    public void setReceiveBufferSize(int bufferSize) {
        if (bufferSize > 0) {
            this.clientContext.getNodeConfig().setReceiveBufferSize(bufferSize);
        }
    }

    public void setRouteMap(Map<String, RouteRule> routeMap) {
        this.clientContext.getNodeConfig().setRouteMap(routeMap);
    }

    public boolean isDispatchOnly() {
        return this.clientContext.getNodeConfig().isDispatchOnly();
    }

    public void setDispatchOnly(boolean dispatchOnly) {
        this.clientContext.getNodeConfig().setDispatchOnly(dispatchOnly);
    }

    public void setFlowControlStrategy(FlowControlStrategy flowControlStrategy) {
        this.clientContext.getNodeConfig().setFlowControlStrategy(flowControlStrategy);
    }

    public void setStoreStrategy(StoreStrategy storeStrategy) {
        this.clientContext.getNodeConfig().setStoreStrategy(storeStrategy);
    }

    public boolean isEnableRedispatch() {
        return this.clientContext.getNodeConfig().isEnableRedispatch();
    }

    public void setEnableRedispatch(boolean enableRedispatch) {
        this.clientContext.getNodeConfig().setEnableRedispatch(enableRedispatch);
    }

    public void setFlowControlStrategyMap(Map<String, FlowControlStrategy> consumerThreadsMap) {
        this.clientContext.getNodeConfig().setFlowControlStrategyMap(consumerThreadsMap);
    }

    public void setEnableIsolateEnvSupport(boolean enableIsolateEnvSupport) {
        this.clientContext.getClientConfig().setEnableIsolateEnvSupport(enableIsolateEnvSupport);
    }

    public void setRouteQueueSize(int routeQueueSize) {
        if (routeQueueSize <= 0) {
            return;
        }
        this.clientContext.getGridTaskSender().getSendManager().setRouteQueueSize(routeQueueSize);
    }

    public void setMergeQueueSize(int mergeQueueSize) {
        if (mergeQueueSize <= 0) {
            return;
        }
        this.clientContext.getGridTaskSender().getSendManager().setMergeQueueSize(mergeQueueSize);
    }

    public void setSendQueueSize(int sendQueueSize) {
        if (sendQueueSize <= 0) {
            return;
        }
        this.clientContext.getGridTaskSender().getSendManager().setSendQueueSize(sendQueueSize);
    }
}

