/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.config;

import com.alibaba.dts.client.executor.grid.flowcontrol.FlowControlStrategy;
import com.alibaba.dts.client.route.RouteRule;
import com.alibaba.dts.client.store.StoreStrategy;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.util.PathUtil;
import com.alibaba.dts.common.util.RemotingUtil;
import com.alibaba.dts.common.util.StringUtil;
import java.util.Map;

public class NodeConfig
implements Constants {
    private int listenPort = 60000;
    private int systemListenPort = this.listenPort + 100;
    private String localAddress;
    private long connectTime;
    private long connectTimeout = 3000L;
    private int remotingThreads = 8;
    private String groupId;
    private long heartbeatInterval = 10000L;
    private String dbPath = PathUtil.getH2Path();
    private int receiveBufferSize = 0x100000;
    private boolean dispatchOnly = false;
    private FlowControlStrategy flowControlStrategy = FlowControlStrategy.NONE;
    private int taskInsertBatchSize = 0;
    private String environment;
    private Map<String, RouteRule> routeMap;
    private Map<String, FlowControlStrategy> flowControlStrategyMap;
    private StoreStrategy storeStrategy = StoreStrategy.DISK;
    private boolean enableRedispatch;

    public int getListenPort() {
        return this.listenPort;
    }

    public void setListenPort(int listenPort) {
        if (listenPort >= 1024 && listenPort <= 65435) {
            this.listenPort = listenPort;
            this.systemListenPort = listenPort + 100;
        }
    }

    public String getLocalAddress() {
        if (StringUtil.isBlank(this.localAddress)) {
            this.localAddress = RemotingUtil.getLocalAddress("SchedulerX".equals(this.environment)) + ":" + this.listenPort;
        }
        return this.localAddress;
    }

    public void setLocalAddress(String localAddress) {
        this.localAddress = StringUtil.isNotBlank(localAddress) ? localAddress : RemotingUtil.getLocalAddress("SchedulerX".equals(this.environment)) + ":" + this.listenPort;
    }

    public int getRemotingThreads() {
        return this.remotingThreads;
    }

    public void setRemotingThreads(int remotingThreads) {
        this.remotingThreads = remotingThreads;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public void setConnectTime(long connectTime) {
        this.connectTime = connectTime;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public long getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public void setHeartbeatInterval(long heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
    }

    public String getDbPath() {
        return this.dbPath;
    }

    public void setDbPath(String dbPath) {
        this.dbPath = dbPath;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public Map<String, RouteRule> getRouteMap() {
        return this.routeMap;
    }

    public void setRouteMap(Map<String, RouteRule> routeMap) {
        this.routeMap = routeMap;
    }

    public boolean isDispatchOnly() {
        return this.dispatchOnly;
    }

    public void setDispatchOnly(boolean dispatchOnly) {
        this.dispatchOnly = dispatchOnly;
    }

    public FlowControlStrategy getFlowControlStrategy() {
        return this.flowControlStrategy;
    }

    public void setFlowControlStrategy(FlowControlStrategy flowControlStrategy) {
        this.flowControlStrategy = flowControlStrategy;
    }

    public void setTaskInsertBatchSize(int taskInsertBatchSize) {
        this.taskInsertBatchSize = taskInsertBatchSize;
    }

    public int getTaskInsertBatchSize() {
        return this.taskInsertBatchSize;
    }

    public StoreStrategy getStoreStrategy() {
        return this.storeStrategy;
    }

    public void setStoreStrategy(StoreStrategy storeStrategy) {
        this.storeStrategy = storeStrategy;
    }

    public int getSystemListenPort() {
        return this.systemListenPort;
    }

    public void setSystemListenPort(int systemListenPort) {
        if (systemListenPort >= 1024 && systemListenPort <= 65535) {
            this.systemListenPort = systemListenPort;
        }
    }

    public boolean isEnableRedispatch() {
        return this.enableRedispatch;
    }

    public void setEnableRedispatch(boolean enableRedispatch) {
        this.enableRedispatch = enableRedispatch;
    }

    public Map<String, FlowControlStrategy> getFlowControlStrategyMap() {
        return this.flowControlStrategyMap;
    }

    public void setFlowControlStrategyMap(Map<String, FlowControlStrategy> flowControlStrategyMap) {
        this.flowControlStrategyMap = flowControlStrategyMap;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String toString() {
        return "NodeConfig{listenPort=" + this.listenPort + ", systemListenPort=" + this.systemListenPort + ", localAddress='" + this.localAddress + '\'' + ", connectTime=" + this.connectTime + ", connectTimeout=" + this.connectTimeout + ", remotingThreads=" + this.remotingThreads + ", groupId='" + this.groupId + '\'' + ", heartbeatInterval=" + this.heartbeatInterval + ", dbPath='" + this.dbPath + '\'' + ", receiveBufferSize=" + this.receiveBufferSize + ", dispatchOnly=" + this.dispatchOnly + ", flowControlStrategy=" + (Object)((Object)this.flowControlStrategy) + ", taskInsertBatchSize=" + this.taskInsertBatchSize + ", routeMap=" + this.routeMap + ", flowControlStrategyMap=" + this.flowControlStrategyMap + ", storeStrategy=" + (Object)((Object)this.storeStrategy) + ", enableRedispatch=" + this.enableRedispatch + ", environment=" + this.environment + '}';
    }
}

