/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.longtime;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.processor.LongTimeJobProcessor;
import com.alibaba.dts.client.executor.longtime.unit.ExecutorUnit;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.CollectionUtils;

public class LongTimePool
implements Constants {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(LongTimePool.class);
    private ConcurrentHashMap<Long, ConcurrentHashMap<Long, ExecutorUnit>> executorUnitTable = new ConcurrentHashMap();
    private final ClientContextImpl clientContext;

    public LongTimePool(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    public void stopService() {
        Iterator<Map.Entry<Long, ConcurrentHashMap<Long, ExecutorUnit>>> iterator = this.executorUnitTable.entrySet().iterator();
        long jobCount = 0L;
        long processorCount = 0L;
        while (iterator.hasNext()) {
            long jobid = 0L;
            ++jobCount;
            try {
                Map.Entry<Long, ConcurrentHashMap<Long, ExecutorUnit>> entry = iterator.next();
                jobid = entry.getKey();
                ConcurrentHashMap<Long, ExecutorUnit> executorUnitMap = entry.getValue();
                if (CollectionUtils.isEmpty(executorUnitMap)) continue;
                Iterator<Map.Entry<Long, ExecutorUnit>> executorUnitIterator = executorUnitMap.entrySet().iterator();
                while (executorUnitIterator.hasNext()) {
                    ++processorCount;
                    Map.Entry<Long, ExecutorUnit> processorEntity = executorUnitIterator.next();
                    ExecutorUnit processor = processorEntity.getValue();
                    processor.stopTask();
                }
            }
            catch (Throwable e) {
                logger.error("[SimplePool]: stopService error, jobid:" + jobid, e);
            }
            logger.info("[SimplePool]: stopService, jobCount:" + jobCount + ", processorCount:" + processorCount);
        }
        this.executorUnitTable.clear();
    }

    public boolean executeTask(ExecutableTask executableTask) {
        ExecutorUnit executorUnit;
        ConcurrentHashMap<Long, ExecutorUnit> executorUnitMap = this.executorUnitTable.get(executableTask.getJob().getId());
        if (null == executorUnitMap) {
            if (!this.isImplProcessor(executableTask)) {
                return false;
            }
            executorUnitMap = new ConcurrentHashMap();
            ConcurrentHashMap<Long, ExecutorUnit> existExecutorUnitMap = this.executorUnitTable.putIfAbsent(executableTask.getJob().getId(), executorUnitMap);
            if (existExecutorUnitMap != null) {
                executorUnitMap = existExecutorUnitMap;
            }
        }
        if (null == (executorUnit = executorUnitMap.get(executableTask.getJobInstanceSnapshot().getId()))) {
            if (!this.isImplProcessor(executableTask)) {
                return false;
            }
            executorUnit = new ExecutorUnit(this.clientContext, this, executableTask);
            ExecutorUnit existExecutorUnit = executorUnitMap.putIfAbsent(executableTask.getJobInstanceSnapshot().getId(), executorUnit);
            if (existExecutorUnit != null) {
                executorUnit = null;
            } else {
                try {
                    executorUnit.init();
                    logger.info("[LongTimePool]: executeTask init success, instanceId:" + executableTask.getJobInstanceSnapshot().getId());
                }
                catch (Throwable e) {
                    logger.error("[LongTimePool]: executeTask init error, instanceId:" + executableTask.getJobInstanceSnapshot().getId(), e);
                    return false;
                }
            }
        } else {
            logger.info("[LongTimePool]: instanceId exists,restartPull, instanceId:" + executableTask.getJobInstanceSnapshot().getId());
            executorUnit.restartPull();
        }
        return true;
    }

    public ExecutorUnit getExecutorUnit(long jobid, long instanceid) {
        ConcurrentHashMap<Long, ExecutorUnit> executorUnitMap = this.executorUnitTable.get(jobid);
        if (null == executorUnitMap) {
            return null;
        }
        ExecutorUnit executorUnit = executorUnitMap.get(instanceid);
        return executorUnit;
    }

    public boolean isImplProcessor(ExecutableTask executableTask) {
        LongTimeJobProcessor longTimeJobProcessor = null;
        try {
            longTimeJobProcessor = this.clientContext.getJobProcessorFactory().createAndGetLongTimeJobProcessor(executableTask.getJob(), false);
        }
        catch (Throwable e) {
            logger.error("[LongTimePool]: LongTimeJobProcessor is not implement., jobProcessor:" + executableTask.getJob().getJobProcessor(), e);
            return false;
        }
        return longTimeJobProcessor != null;
    }

    public boolean activeTask(ExecutableTask executableTask) {
        ExecutorUnit executorUnit;
        ConcurrentHashMap<Long, ExecutorUnit> executorUnitMap = this.executorUnitTable.get(executableTask.getJob().getId());
        if (null == executorUnitMap) {
            executorUnitMap = new ConcurrentHashMap();
            this.executorUnitTable.put(executableTask.getJob().getId(), executorUnitMap);
        }
        if (null == (executorUnit = executorUnitMap.get(executableTask.getJobInstanceSnapshot().getId()))) {
            executorUnit = new ExecutorUnit(this.clientContext, this, executableTask);
            try {
                executorUnit.activeInit();
                logger.info("[LongTimePool]: activeTask init success, instanceId:" + executableTask.getJobInstanceSnapshot().getId());
            }
            catch (Throwable e) {
                logger.error("[LongTimePool]: activeTask init error, instanceId:" + executableTask.getJobInstanceSnapshot().getId(), e);
                return false;
            }
            executorUnitMap.put(executableTask.getJobInstanceSnapshot().getId(), executorUnit);
        }
        return true;
    }

    public boolean releaseCompleteTask(ExecutableTask executableTask) {
        boolean result = true;
        try {
            ConcurrentHashMap<Long, ExecutorUnit> executorUnitMap = this.executorUnitTable.get(executableTask.getJob().getId());
            if (null == executorUnitMap) {
                return false;
            }
            ExecutorUnit executorUnit = executorUnitMap.get(executableTask.getJobInstanceSnapshot().getId());
            if (null == executorUnit) {
                return false;
            }
            executorUnit.releaseCompleteTask();
            logger.info("[LongTimePool]: activeTask releaseCompleteTask success, instanceId:" + executableTask.getJobInstanceSnapshot().getId());
        }
        catch (Throwable e) {
            result = false;
            logger.error("[LongTimePool]: releaseCompleteTask error, instanceId:" + executableTask.getJobInstanceSnapshot().getId(), e);
        }
        return result;
    }

    public boolean stopTask(long jobId, long jobInstanceId) {
        ConcurrentHashMap<Long, ExecutorUnit> executorUnitMap = this.executorUnitTable.get(jobId);
        if (null == executorUnitMap || executorUnitMap.isEmpty()) {
            return true;
        }
        ExecutorUnit executorUnit = executorUnitMap.get(jobInstanceId);
        if (null == executorUnit) {
            return true;
        }
        executorUnit.stopTask();
        try {
            executorUnitMap.remove(jobInstanceId);
            logger.info("[LongTimePool]: stopTask remove executorUnitMap success, instanceId:" + jobInstanceId);
        }
        catch (Throwable e) {
            logger.error("[LongTimePool]: stopTask remove executorUnitMap error, jobId:" + jobId + ", jobInstanceId:" + jobInstanceId, e);
            return false;
        }
        return true;
    }

    public boolean forceStopTask(long jobId, long jobInstanceId) {
        ConcurrentHashMap<Long, ExecutorUnit> executorUnitMap = this.executorUnitTable.get(jobId);
        if (null == executorUnitMap || executorUnitMap.isEmpty()) {
            return true;
        }
        ExecutorUnit executorUnit = executorUnitMap.get(jobInstanceId);
        if (null == executorUnit) {
            return true;
        }
        executorUnit.forceStopTask();
        try {
            executorUnitMap.remove(jobInstanceId);
            logger.info("[LongTimePool]: forceStopTask remove executorUnitMap success, instanceId:" + jobInstanceId);
        }
        catch (Throwable e) {
            logger.error("[LongTimePool]: forceStopTask remove executorUnitMap error, jobId:" + jobId + ", jobInstanceId:" + jobInstanceId, e);
            return false;
        }
        return true;
    }

    public Result<String> heartBeatCheckJobInstance(long jobId, long jobInstanceId) {
        Result<String> result = new Result<String>();
        ConcurrentHashMap<Long, ExecutorUnit> executorUnitMap = this.executorUnitTable.get(jobId);
        if (null == executorUnitMap || executorUnitMap.isEmpty()) {
            result.setResultCode(ResultCode.HEART_BEAT_CHECK_EXIT);
            return result;
        }
        ExecutorUnit executorUnit = executorUnitMap.get(jobInstanceId);
        if (null == executorUnit) {
            result.setResultCode(ResultCode.HEART_BEAT_CHECK_EXIT);
            return result;
        }
        result.setResultCode(ResultCode.HEART_BEAT_CHECK_SUCCESS);
        logger.info("[LongTimePool]: heartBeatCheckJobInstance, jobId:" + jobId + ", jobInstanceId:" + jobInstanceId + ", result:" + result.getResultCode().getInformation());
        return result;
    }

    public Result<Boolean> push(long jobId, long jobInstanceId, TaskSnapshot taskSnapshot) {
        ConcurrentHashMap<Long, ExecutorUnit> executorUnitMap = this.executorUnitTable.get(jobId);
        if (null == executorUnitMap || executorUnitMap.isEmpty()) {
            return new Result<Boolean>(false, ResultCode.PUSH_UNIT_MAP_IS_EMPTY_ERROR);
        }
        ExecutorUnit executorUnit = executorUnitMap.get(jobInstanceId);
        if (null == executorUnit) {
            return new Result<Boolean>(false, ResultCode.PUSH_UNIT_IS_NULL_ERROR);
        }
        boolean result = false;
        try {
            result = executorUnit.offer(taskSnapshot);
            logger.info("[LongTimePool]: push success, result:" + result + ", jobId:" + jobId + ", jobInstanceId:" + jobInstanceId);
        }
        catch (Throwable e) {
            logger.error("[LongTimePool]: push error, jobId:" + jobId + ", jobInstanceId:" + jobInstanceId, e);
        }
        return new Result<Boolean>(result, result ? ResultCode.SUCCESS : ResultCode.FAILURE);
    }
}

