/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.executor.parallel.processor;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.client.executor.job.context.JobContextImpl;
import com.alibaba.dts.client.executor.parallel.processor.ParallelJobContext;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.context.InvocationContext;
import com.alibaba.dts.common.domain.ExecutableTask;
import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.domain.store.Job;
import com.alibaba.dts.common.domain.store.JobInstanceSnapshot;
import com.alibaba.dts.common.domain.store.TaskSnapshot;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.service.ServerService;
import com.alibaba.dts.common.util.BytesUtil;
import com.alibaba.dts.common.util.BytesUtil4Client;
import com.alibaba.dts.common.util.RandomUtil;
import com.alibaba.dts.common.util.StringUtil;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class ParallelJobContextImpl
extends JobContextImpl
implements Constants,
ParallelJobContext {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(ParallelJobContextImpl.class);
    private TaskSnapshot taskSnapshot;
    private Object task;
    private String taskName;
    private int availableMachineAmount;
    private int currentMachineNumber;
    private ServerService serverService;
    private final ClientContextImpl clientContext;

    public ParallelJobContextImpl(ClientContextImpl clientContext, Job job, JobInstanceSnapshot jobInstanceSnapshot, int retryCount) {
        super(job, jobInstanceSnapshot, retryCount);
        this.clientContext = clientContext;
        this.serverService = this.clientContext.getClientRemoting().proxyInterface(ServerService.class);
    }

    @Override
    public void initRetryCount(int retryCount) {
        super.setRetryCount(retryCount);
    }

    @Override
    public void setTask(TaskSnapshot taskSnapshot) {
        this.taskSnapshot = taskSnapshot;
        this.taskName = taskSnapshot.getTaskName();
        if ("defaultTaskName4DtsServerSelf".equals(taskSnapshot.getTaskName())) {
            if (BytesUtil.isEmpty(taskSnapshot.getBody())) {
                logger.error("[ParallelJobContext]: BytesUtil setTask bytesToObject error, body is empty, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId());
                return;
            }
            try {
                this.task = BytesUtil.bytesToObject(taskSnapshot.getBody());
            }
            catch (Throwable e) {
                logger.error("[ParallelJobContext]: BytesUtil setTask bytesToObject error, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId(), e);
            }
        } else {
            if (BytesUtil4Client.isEmpty(taskSnapshot.getBody())) {
                logger.error("[ParallelJobContext]: BytesUtil4Client setTask bytesToObject error, body is empty, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId());
                return;
            }
            try {
                this.task = BytesUtil4Client.bytesToObject(taskSnapshot.getBody());
            }
            catch (Throwable e) {
                logger.error("[ParallelJobContext]: BytesUtil4Client setTask bytesToObject error, instanceId:" + taskSnapshot.getJobInstanceId() + ", id:" + taskSnapshot.getId(), e);
            }
        }
    }

    @Override
    public Result<Boolean> dispatchTaskList(List<? extends Object> taskList, String taskName) {
        Result<Boolean> result = new Result<Boolean>(false);
        if (StringUtil.isBlank(taskName)) {
            logger.error("[ParallelJobContext]: dispatchTaskList taskName is isEmpty error, jobId:" + this.job.getId());
            result.setResultCode(ResultCode.DISPATCH_TASK_LIST_NAME_IS_NULL);
            return result;
        }
        if (CollectionUtils.isEmpty(taskList)) {
            logger.warn("[ParallelJobContext]: dispatchTaskList taskList is empty, taskName:" + taskName + ", jobId:" + this.job.getId());
            result.setResultCode(ResultCode.DISPATCH_TASK_LIST_IS_EMPTY);
            return result;
        }
        if (taskList.size() > 3000) {
            throw new RuntimeException("taskList size too large, max:3000, but you set " + taskList.size());
        }
        List<String> serverList = this.clientContext.getClientRemoting().getServerList();
        if (CollectionUtils.isEmpty(serverList)) {
            logger.error("[ParallelJobContext]: dispatchTaskList serverList is isEmpty error, taskName:" + taskName + ", jobId:" + this.job.getId());
            result.setResultCode(ResultCode.DISPATCH_TASK_LIST_SERVER_DOWN);
            return result;
        }
        ExecutableTask executableTask = new ExecutableTask(this.job, this.jobInstanceSnapshot);
        executableTask.setTaskSnapshot(this.taskSnapshot);
        for (Object object : taskList) {
            this.fillTaskSnapshot(executableTask, object, taskName);
        }
        Collections.shuffle(serverList);
        for (String string : serverList) {
            Result<Boolean> sendResult = null;
            try {
                InvocationContext.setRemoteMachine(new RemoteMachine(string, 60000L));
                sendResult = this.serverService.send(executableTask);
            }
            catch (Throwable e) {
                logger.error("[ParallelJobContext]: dispatchTaskList sendOld error, taskName:" + taskName + ", jobId:" + this.job.getId() + ", server:" + string, e);
            }
            if (null == sendResult || !sendResult.getData().booleanValue()) {
                logger.error("[ParallelJobContext]: dispatchTaskList sendOld failed, taskName:" + taskName + ", jobId:" + this.job.getId() + ", server:" + string);
                result.setData(null == sendResult ? false : sendResult.getData());
                result.setResultCode(null == sendResult ? ResultCode.DISPATCH_TASK_LIST_SERVER_DO_NOT_RESPONSE : sendResult.getResultCode());
                continue;
            }
            result.setData(sendResult.getData());
            result.setResultCode(sendResult.getResultCode());
            return result;
        }
        return result;
    }

    @Override
    public void fillTaskSnapshot(ExecutableTask executableTask, Object task, String taskName) {
        byte[] body = null;
        try {
            body = BytesUtil4Client.objectToBytes(task);
        }
        catch (Throwable e) {
            logger.error("[ParallelJobContext]: fillTaskSnapshot objectToBytes error, taskName:" + taskName + ", jobId:" + this.job.getId() + ", task:" + task, e);
        }
        if (BytesUtil4Client.isEmpty(body)) {
            logger.error("[ParallelJobContext]: fillTaskSnapshot objectToBytes body is empty, taskName:" + taskName + ", jobId:" + this.job.getId() + ", task:" + task);
            return;
        }
        if ((long)body.length > this.clientContext.getClientConfig().getMaxBodySize()) {
            throw new RuntimeException("[ParallelJobContext]: single task is too large, more than 64KB");
        }
        TaskSnapshot taskSnapshot = new TaskSnapshot();
        taskSnapshot.setGmtCreate(new Date());
        taskSnapshot.setGmtModified(new Date());
        taskSnapshot.setJobInstanceId(executableTask.getJobInstanceSnapshot().getId());
        taskSnapshot.setJobProcessor(executableTask.getJob().getJobProcessor());
        taskSnapshot.setBody(body);
        taskSnapshot.setStatus(0);
        taskSnapshot.setTaskName(taskName);
        taskSnapshot.setRetryCount(0);
        executableTask.addTaskSnapshot(taskSnapshot);
    }

    @Override
    public Object getTask() {
        return this.task;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public String getGlobalArguments() {
        List<String> serverList = this.clientContext.getClientRemoting().getServerList();
        if (CollectionUtils.isEmpty(serverList)) {
            logger.error("[ParallelJobContext]: getGlobalArguments serverList is isEmpty error, instanceId:" + this.jobInstanceSnapshot.getId());
            return null;
        }
        InvocationContext.setRemoteMachine(new RemoteMachine(RandomUtil.getRandomObj(serverList)));
        Result<String> body = this.serverService.getGlobalArguments(this.jobInstanceSnapshot);
        if (null == body) {
            logger.error("[ParallelJobContext]: getGlobalArguments body is null, instanceId:" + this.jobInstanceSnapshot.getId());
            return null;
        }
        return body.getData();
    }

    @Override
    public Result<Boolean> setGlobalArguments(String globalArguments) {
        Result<Boolean> result = new Result<Boolean>(false);
        if (StringUtil.isBlank(globalArguments)) {
            result.setResultCode(ResultCode.SET_GLOBAL_ARGUMENTS_NULL);
            return result;
        }
        List<String> serverList = this.clientContext.getClientRemoting().getServerList();
        if (CollectionUtils.isEmpty(serverList)) {
            logger.error("[ParallelJobContext]: setGlobalArguments serverList is isEmpty error, instanceId:" + this.jobInstanceSnapshot.getId());
            result.setResultCode(ResultCode.SET_GLOBAL_SERVER_DOWN);
            return result;
        }
        InvocationContext.setRemoteMachine(new RemoteMachine(RandomUtil.getRandomObj(serverList)));
        Result<Boolean> setResult = this.serverService.setGlobalArguments(this.jobInstanceSnapshot, globalArguments);
        if (null == setResult) {
            result.setResultCode(ResultCode.SET_GLOBAL_FAILURE);
            return result;
        }
        result.setData(setResult.getData());
        result.setResultCode(setResult.getResultCode());
        return result;
    }

    @Override
    public int getAvailableMachineAmount() {
        return this.availableMachineAmount;
    }

    @Override
    public void setAvailableMachineAmount(int availableMachineAmount) {
        this.availableMachineAmount = availableMachineAmount;
    }

    @Override
    public int getCurrentMachineNumber() {
        return this.currentMachineNumber;
    }

    @Override
    public void setCurrentMachineNumber(int currentMachineNumber) {
        this.currentMachineNumber = currentMachineNumber;
    }
}

