/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.remoting.listener;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.helper.RemotingHelper;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.remoting.ChannelEventListener;
import com.alibaba.dts.common.util.RemotingUtil;
import com.alibaba.dts.shade.io.netty.channel.Channel;

public class ServerChannelEventListener
implements ChannelEventListener {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(ServerChannelEventListener.class);
    private ClientContextImpl clientContext;

    public ServerChannelEventListener(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    @Override
    public void onChannelConnect(String remoteAddr, Channel channel) {
        String remoteAddress = RemotingHelper.parseChannelRemoteAddr(channel);
        logger.info("[ServerChannelEventListener]: onChannelConnect {" + remoteAddress + "}");
    }

    @Override
    public void onChannelClose(String remoteAddr, Channel channel) {
        String remoteAddress = RemotingUtil.socketAddress2String(channel.remoteAddress());
        this.clientContext.getNodeRemoting().deleteConnection(remoteAddress);
        RemotingUtil.closeChannel(channel);
    }

    @Override
    public void onChannelException(String remoteAddr, Channel channel) {
        String remoteAddress = RemotingUtil.socketAddress2String(channel.remoteAddress());
        this.clientContext.getNodeRemoting().deleteConnection(remoteAddress);
        RemotingUtil.closeChannel(channel);
        logger.warn("[ServerChannelEventListener]: onChannelException {" + remoteAddress + "}");
    }

    @Override
    public void onChannelIdle(String remoteAddr, Channel channel) {
        String remoteAddress = RemotingHelper.parseChannelRemoteAddr(channel);
        logger.info("[ServerChannelEventListener]: onChannelIdle {" + remoteAddress + "}");
    }
}

