/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.remoting.processor;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.context.InvocationContext;
import com.alibaba.dts.common.domain.remoting.protocol.InvokeMethod;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.helper.RemotingHelper;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.common.proxy.ProxyService;
import com.alibaba.dts.common.remoting.netty.NettyRequestProcessor;
import com.alibaba.dts.common.remoting.protocol.RemotingCommand;
import com.alibaba.dts.common.remoting.protocol.RemotingSerializable;
import com.alibaba.dts.common.util.BytesUtil;
import com.alibaba.dts.common.util.StringUtil;
import com.alibaba.dts.shade.io.netty.channel.ChannelHandlerContext;

public class NodeClientRequestProcessor
implements NettyRequestProcessor {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(NodeClientRequestProcessor.class);
    private ClientContextImpl clientContext;

    public NodeClientRequestProcessor(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    @Override
    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws Exception {
        byte[] requestBody = request.getBody();
        if (null == requestBody) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error("[ClientRequestProcessor]: requestBody is null, remoteAddress:" + remoteAddress);
            return new RemotingCommand();
        }
        String json = null;
        try {
            json = (String)BytesUtil.bytesToObject(requestBody);
        }
        catch (Throwable e) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error("[ClientRequestProcessor]: bytesToObject error, remoteAddress:" + remoteAddress, e);
            return new RemotingCommand();
        }
        if (StringUtil.isBlank(json)) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error("[ClientRequestProcessor]: json is null, remoteAddress:" + remoteAddress);
            return new RemotingCommand();
        }
        InvokeMethod invokeMethod = InvokeMethod.newInstance(json);
        invokeMethod.getRemoteMachine().setChannel(ctx.channel());
        InvocationContext.setRemoteMachine(invokeMethod.getRemoteMachine());
        Object result = this.clientContext.getProxyService().invokeMethod(this.clientContext.getNodeClientService(), invokeMethod.getMethodName(), invokeMethod.getClassArray(), invokeMethod.getObjectArray());
        InvocationContext.clean();
        Class<?> returnClass = ProxyService.getClass(invokeMethod.getReturnType());
        if (Void.TYPE == returnClass) {
            return new RemotingCommand();
        }
        if (null == result) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error("[ClientRequestProcessor]: result is null, remoteAddress:" + remoteAddress + ", invokeMethod:" + invokeMethod);
            return new RemotingCommand();
        }
        if (ResultCode.NO_SUCH_METHOD.equals(result)) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error("[ClientRequestProcessor]: NO_SUCH_METHOD, remoteAddress:" + remoteAddress + ", invokeMethod:" + invokeMethod);
            byte[] resultBody = null;
            try {
                resultBody = BytesUtil.objectToBytes(RemotingSerializable.toJson(ResultCode.NO_SUCH_METHOD, false));
            }
            catch (Throwable e) {
                logger.error("[ClientRequestProcessor]: NO_SUCH_METHOD objectToBytes error, remoteAddress:" + remoteAddress + ", invokeMethod:" + invokeMethod, e);
            }
            RemotingCommand response = new RemotingCommand();
            response.setBody(resultBody);
            return response;
        }
        byte[] responseBody = null;
        try {
            responseBody = BytesUtil.objectToBytes(RemotingSerializable.toJson(result, false));
        }
        catch (Throwable e) {
            String remoteAddress = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
            logger.error("[ClientRequestProcessor]: objectToBytes error, remoteAddress:" + remoteAddress + ", invokeMethod:" + invokeMethod, e);
            return new RemotingCommand();
        }
        RemotingCommand response = new RemotingCommand();
        response.setBody(responseBody);
        return response;
    }
}

