/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.security;

import com.alibaba.dts.client.executor.job.context.ClientContextImpl;
import com.alibaba.dts.common.constants.Constants;
import com.alibaba.dts.common.domain.result.Result;
import com.alibaba.dts.common.domain.result.ResultCode;
import com.alibaba.dts.common.exception.InitException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import com.alibaba.dts.shade.com.taobao.spas.sdk.client.SpasSdkClientFacade;
import com.alibaba.dts.shade.com.taobao.spas.sdk.client.identity.Credentials;
import com.alibaba.dts.shade.com.taobao.spas.sdk.common.sign.SpasSigner;
import java.net.URLEncoder;

public class SecurityCheck
implements Constants {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(SecurityCheck.class);
    private static Credentials credentials = SpasSdkClientFacade.getCredential();
    private final ClientContextImpl clientContext;

    public SecurityCheck(ClientContextImpl clientContext) {
        this.clientContext = clientContext;
    }

    public void init() throws InitException {
        if (credentials.getAccessKey() == null || credentials.getSecretKey() == null) {
            throw new InitException("[SecurityCheck]: AK or SK is Null!");
        }
        this.clientContext.getClientConfig().setAccessKey(credentials.getAccessKey());
    }

    public String getSignatureStr(long connectTime) {
        if ("SchedulerX".equals(this.clientContext.getClientConfig().getEnvironment())) {
            if (credentials.getAccessKey() == null || credentials.getSecretKey() == null) {
                return "Invalid AKSK";
            }
            String signdata = this.clientContext.getClientConfig().getGroupId() + connectTime;
            String sign = SpasSigner.sign(signdata, credentials.getSecretKey());
            return sign;
        }
        return "";
    }

    public void doSecurityCheck() throws InitException {
        String signdata = "schedulerX:" + this.clientContext.getClientConfig().getServiceGroup() + System.currentTimeMillis();
        String sign = SpasSigner.sign(signdata, credentials.getSecretKey());
        Result<String> result = this.clientContext.getHttpService().securityCheck(this.clientContext.getClientConfig().getDomainName(), this.clientContext.getClientConfig().getAccessKey(), "schedulerX:" + this.clientContext.getClientConfig().getServiceGroup(), signdata, URLEncoder.encode(sign));
        if (result.getResultCode() == null) {
            throw new InitException("[SecurityCheck]: check ak error, return null!");
        }
        if (result.getResultCode() != ResultCode.SUCCESS) {
            throw new InitException("[SecurityCheck]: check ak error," + result.getResultCode().getInformation());
        }
    }
}

