/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.client.store.access.impl;

import com.alibaba.dts.client.store.access.ExecutionCounterDao;
import com.alibaba.dts.client.store.access.impl.TaskSnapshotDaoH2;
import com.alibaba.dts.common.domain.store.ExecutionCounter;
import com.alibaba.dts.common.exception.AccessException;
import com.alibaba.dts.common.logger.SchedulerXLoggerFactory;
import com.alibaba.dts.common.logger.innerlog.Logger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import javax.sql.DataSource;

public class ExecutionCounterDaoH2
implements ExecutionCounterDao {
    private static final Logger logger = SchedulerXLoggerFactory.getLogger(TaskSnapshotDaoH2.class);
    private DataSource dataSource;

    public ExecutionCounterDaoH2(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public int createExecutionCounterTable() throws AccessException {
        int result = 0;
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS `DTS_EXECUTION_COUNTER` (        `id` bigint(20) NOT NULL AUTO_INCREMENT,        `gmt_create` datetime DEFAULT NULL,        `gmt_modified` datetime DEFAULT NULL,        `job_id` bigint(20) DEFAULT NULL,        `job_instance_id` bigint(20) DEFAULT NULL,        `receive_node` varchar(255) DEFAULT NULL,        `task_name` varchar(255) DEFAULT NULL,        `total_counter` bigint(20),        `queued_counter` bigint(20),        `running_counter` bigint(20),        `success_counter` bigint(20),        `fail_counter` bigint(20),        PRIMARY KEY (`id`)        ) ; ");
            result = preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new AccessException("[createExecutionCounterTable]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
        return result;
    }

    @Override
    public int updateExecutionCounter(ExecutionCounter executionCounter) throws AccessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int createExecutionCounter(ExecutionCounter executionCounter) throws AccessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ExecutionCounter> list() throws AccessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExecutionCounter get(Long jobInstanceId) {
        return null;
    }

    @Override
    public ExecutionCounter getByJobInstanceAndExecutionNode(Long jobInstanceId, String receiveNode) throws AccessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Long> listJobInstances() throws AccessException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long deleteByJobInstanceId(long jobInstanceId) throws AccessException {
        int result = 0;
        Connection connection = null;
        Statement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            preparedStatement = connection.prepareStatement("DELETE FROM DTS_EXECUTION_COUNTER WHERE id=?");
            preparedStatement.setLong(1, jobInstanceId);
            result = preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            throw new AccessException("[delete]: error", e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), e);
                }
            }
        }
        return result;
    }

    @Override
    public ExecutionCounter getByJobInstanceAndExecutionNodeAndTaskName(Long jobInstanceId, String receiveNode, String taskName) throws AccessException {
        throw new UnsupportedOperationException();
    }
}

