/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dts.common.domain.remoting.protocol;

import com.alibaba.dts.common.domain.remoting.RemoteMachine;
import com.alibaba.dts.common.proxy.ProxyService;
import com.alibaba.dts.common.remoting.protocol.RemotingSerializable;

public class InvokeMethod {
    private RemoteMachine remoteMachine;
    private String methodName;
    private String[] parameterTypes;
    private String[] arguments;
    private String returnType;
    private transient Class<?>[] classArray;
    private transient Object[] objectArray;

    public InvokeMethod() {
    }

    public InvokeMethod(RemoteMachine remoteMachine, String methodName, String[] parameterTypes, String[] arguments, String returnType) {
        this.remoteMachine = remoteMachine;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.arguments = arguments;
        this.returnType = returnType;
    }

    public void initParameters() {
        this.classArray = new Class[this.parameterTypes.length];
        this.objectArray = new Object[this.parameterTypes.length];
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            this.classArray[i] = ProxyService.getClass(this.parameterTypes[i]);
            this.objectArray[i] = RemotingSerializable.fromJson(this.arguments[i], this.classArray[i]);
        }
    }

    public static InvokeMethod newInstance(String json) {
        InvokeMethod invokeMethod = RemotingSerializable.fromJson(json, InvokeMethod.class);
        invokeMethod.getRemoteMachine().reversal();
        invokeMethod.initParameters();
        return invokeMethod;
    }

    public String toString() {
        return RemotingSerializable.toJson(this, false);
    }

    public RemoteMachine getRemoteMachine() {
        return this.remoteMachine;
    }

    public void setRemoteMachine(RemoteMachine remoteMachine) {
        this.remoteMachine = remoteMachine;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(String[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public Class<?>[] getClassArray() {
        return this.classArray;
    }

    public void setClassArray(Class<?>[] classArray) {
        this.classArray = classArray;
    }

    public Object[] getObjectArray() {
        return this.objectArray;
    }

    public void setObjectArray(Object[] objectArray) {
        this.objectArray = objectArray;
    }
}

